/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.utils.jc;

import cn.nkpro.elcube.utils.jc.CharSequenceJavaFileObject;
import cn.nkpro.elcube.utils.jc.JdkDynamicCompileClassLoader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JdkDynamicCompileJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final JdkDynamicCompileClassLoader classLoader;
    private final Map<URI, JavaFileObject> javaFileObjectMap = new HashMap<URI, JavaFileObject>();

    public JdkDynamicCompileJavaFileManager(JavaFileManager fileManager, JdkDynamicCompileClassLoader classLoader) {
        super(fileManager);
        this.classLoader = classLoader;
    }

    private static URI fromLocation(JavaFileManager.Location location, String packageName, String relativeName) {
        try {
            return new URI(location.getName() + '/' + packageName + '/' + relativeName);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        JavaFileObject javaFileObject = this.javaFileObjectMap.get(JdkDynamicCompileJavaFileManager.fromLocation(location, packageName, relativeName));
        if (null != javaFileObject) {
            return javaFileObject;
        }
        return super.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        CharSequenceJavaFileObject javaFileObject = new CharSequenceJavaFileObject(className, kind);
        this.classLoader.addJavaFileObject(className, javaFileObject);
        return javaFileObject;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof CharSequenceJavaFileObject) {
            return file.getName();
        }
        return super.inferBinaryName(location, file);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> superResult = super.list(location, packageName, kinds, recurse);
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            for (JavaFileObject file : this.javaFileObjectMap.values()) {
                if (file.getKind() != JavaFileObject.Kind.CLASS || !file.getName().startsWith(packageName)) continue;
                result.add(file);
            }
            result.addAll(this.classLoader.listJavaFileObject());
        } else if (location == StandardLocation.SOURCE_PATH && kinds.contains((Object)JavaFileObject.Kind.SOURCE)) {
            for (JavaFileObject file : this.javaFileObjectMap.values()) {
                if (file.getKind() != JavaFileObject.Kind.SOURCE || !file.getName().startsWith(packageName)) continue;
                result.add(file);
            }
        }
        for (JavaFileObject javaFileObject : superResult) {
            result.add(javaFileObject);
        }
        return result;
    }

    public void addJavaFileObject(JavaFileManager.Location location, String packageName, String relativeName, JavaFileObject javaFileObject) {
        this.javaFileObjectMap.put(JdkDynamicCompileJavaFileManager.fromLocation(location, packageName, relativeName), javaFileObject);
    }
}

