/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.utils.jc;

import cn.nkpro.elcube.utils.jc.CharSequenceJavaFileObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.tools.JavaFileObject;

public class JdkDynamicCompileClassLoader
extends ClassLoader {
    private static final String CLASS_EXTENSION = ".class";
    private final Map<String, JavaFileObject> javaFileObjectMap = new HashMap<String, JavaFileObject>();

    public JdkDynamicCompileClassLoader(ClassLoader parentClassLoader) {
        super(parentClassLoader);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        JavaFileObject javaFileObject = this.javaFileObjectMap.get(name);
        if (null != javaFileObject) {
            CharSequenceJavaFileObject charSequenceJavaFileObject = (CharSequenceJavaFileObject)javaFileObject;
            byte[] byteCode = charSequenceJavaFileObject.getByteCode();
            return this.defineClass(name, byteCode, 0, byteCode.length);
        }
        return super.findClass(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        String qualifiedClassName;
        CharSequenceJavaFileObject javaFileObject;
        if (name.endsWith(CLASS_EXTENSION) && null != (javaFileObject = (CharSequenceJavaFileObject)this.javaFileObjectMap.get(qualifiedClassName = name.substring(0, name.length() - CLASS_EXTENSION.length()).replace('/', '.'))) && null != javaFileObject.getByteCode()) {
            return new ByteArrayInputStream(javaFileObject.getByteCode());
        }
        return super.getResourceAsStream(name);
    }

    void addJavaFileObject(String qualifiedClassName, JavaFileObject javaFileObject) {
        this.javaFileObjectMap.put(qualifiedClassName, javaFileObject);
    }

    Collection<JavaFileObject> listJavaFileObject() {
        return Collections.unmodifiableCollection(this.javaFileObjectMap.values());
    }
}

