/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.utils.jc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class CharSequenceJavaFileObject
extends SimpleJavaFileObject {
    public static final String CLASS_EXTENSION = ".class";
    public static final String JAVA_EXTENSION = ".java";
    private ByteArrayOutputStream byteCode;
    private final CharSequence sourceCode;

    private static URI fromClassName(String className) {
        try {
            return new URI(className);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(className, e);
        }
    }

    public CharSequenceJavaFileObject(String className, CharSequence sourceCode) {
        super(CharSequenceJavaFileObject.fromClassName(className + JAVA_EXTENSION), JavaFileObject.Kind.SOURCE);
        this.sourceCode = sourceCode;
    }

    public CharSequenceJavaFileObject(String fullClassName, JavaFileObject.Kind kind) {
        super(CharSequenceJavaFileObject.fromClassName(fullClassName), kind);
        this.sourceCode = null;
    }

    public CharSequenceJavaFileObject(URI uri, JavaFileObject.Kind kind) {
        super(uri, kind);
        this.sourceCode = null;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return this.sourceCode;
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.getByteCode());
    }

    @Override
    public OutputStream openOutputStream() {
        this.byteCode = new ByteArrayOutputStream();
        return this.byteCode;
    }

    public byte[] getByteCode() {
        return this.byteCode.toByteArray();
    }
}

