/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OsUtils {
    private static String macAddressStr = null;
    private static final String[] windowsCommand = new String[]{"ipconfig", "/all"};
    private static final String[] linuxCommand = new String[]{"/sbin/ifconfig", "-a"};
    private static final Pattern macPattern = Pattern.compile(".*((:?[0-9a-f]{2}[-:]){5}[0-9a-f]{2}).*", 2);

    private static List getMacAddressList() throws IOException {
        String line;
        String[] command;
        ArrayList<String> macAddressList = new ArrayList<String>();
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            command = windowsCommand;
        } else if (os.startsWith("Linux") || os.startsWith("Mac")) {
            command = linuxCommand;
        } else {
            throw new IOException("Unknow operating system:" + os);
        }
        Process process = Runtime.getRuntime().exec(command);
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = bufReader.readLine()) != null) {
            Matcher matcher = macPattern.matcher(line);
            if (!matcher.matches()) continue;
            macAddressList.add(matcher.group(1));
        }
        process.destroy();
        bufReader.close();
        return macAddressList;
    }

    public static String getMacAddress() {
        if (macAddressStr == null || macAddressStr.equals("")) {
            StringBuilder sb = new StringBuilder();
            try {
                List macList = OsUtils.getMacAddressList();
                for (Object o : macList) {
                    String mac = (String)o;
                    if (mac.equals("0000000000E0")) continue;
                    sb.append(mac);
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            macAddressStr = sb.toString();
        }
        return macAddressStr;
    }
}

