/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;

public interface DateTimeUtilz {
    public static String todayShortString() {
        return new SimpleDateFormat("yyyyMMdd").format(new Date());
    }

    public static Long nowSeconds() {
        return Calendar.getInstance().getTimeInMillis() / 1000L;
    }

    public static Long todaySeconds() {
        Calendar instance = Calendar.getInstance();
        instance.set(11, 0);
        instance.set(12, 0);
        instance.set(13, 0);
        instance.set(14, 0);
        return instance.getTimeInMillis() / 1000L;
    }

    public static Long dateAdd(Long seconds, int day) {
        return seconds + (long)(86400 * day);
    }

    public static long dateDiff(Long toSeconds, Long fromSeconds) {
        return (toSeconds - fromSeconds) / 60L / 60L / 24L;
    }

    public static Long monthAdd(Long seconds, int month) {
        Calendar instance = Calendar.getInstance();
        instance.setTimeInMillis(seconds * 1000L);
        instance.add(2, month);
        return instance.getTimeInMillis() / 1000L;
    }

    public static String format(Long seconds, String format) {
        Calendar instance = Calendar.getInstance();
        instance.setTimeInMillis(seconds * 1000L);
        return new SimpleDateFormat(format).format(instance.getTime());
    }

    public static Long stringToDateLong(String str, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        if (null == pattern) {
            dateFormat = new SimpleDateFormat("yyyy-dMM-dd");
        }
        Date date = null;
        try {
            date = dateFormat.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getTimeInMillis() / 1000L;
    }

    public static Date getLastDayOfMonth(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int lastDay = calendar.getActualMaximum(5);
        try {
            return format.parse(year + "-" + month + "-" + lastDay + " 23:59:59");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Long fromISO(String isoDate) {
        return Instant.parse(isoDate).getEpochSecond();
    }
}

