/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.utils;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

public interface ClassUtils {
    public static String decapitateClassName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String decapitateBeanName(Class<?> clazz) {
        Service service;
        String beanName = ClassUtils.decapitateClassName(clazz.getSimpleName());
        Component component = clazz.getDeclaredAnnotation(Component.class);
        if (component != null && StringUtils.isNotBlank((CharSequence)component.value())) {
            beanName = component.value();
        }
        if ((service = clazz.getDeclaredAnnotation(Service.class)) != null && StringUtils.isNotBlank((CharSequence)service.value())) {
            beanName = service.value();
        }
        return beanName;
    }

    public static boolean hasInterface(Class<?> clazz, Class<?> targetInterface) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (i != targetInterface) continue;
            return true;
        }
        if ((clazz = clazz.getSuperclass()) == null || clazz == Object.class) {
            return false;
        }
        return ClassUtils.hasInterface(clazz, targetInterface);
    }
}

