/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;

public interface BeanUtilz {
    public static <T> T cloneWithFastjson(Object source, Type type) {
        if (source == null) {
            return null;
        }
        return (T)JSON.parseObject((String)JSON.toJSONString((Object)source), (Type)type, (Feature[])new Feature[0]);
    }

    public static <T> T copyFromObject(Object source, T target) {
        if (source != null) {
            BeanUtils.copyProperties((Object)source, target);
        }
        return target;
    }

    public static <T> T copyFromObject(Object source, Class<T> type) {
        if (source != null) {
            Object target = BeanUtils.instantiateClass(type);
            BeanUtils.copyProperties((Object)source, (Object)target);
            return (T)target;
        }
        return null;
    }

    public static <T> List<T> copyFromList(List<?> source, Class<T> type) {
        return BeanUtilz.copyFromList(source, type, obj -> {});
    }

    public static <T> List<T> copyFromList(List<?> source, Class<T> type, Function<T> mapper) {
        return source.stream().map(item -> {
            Object target = BeanUtilz.copyFromObject(item, type);
            mapper.apply(target);
            return target;
        }).collect(Collectors.toList());
    }

    public static <K, D> void diffList(List<D> list1, List<D> list2, java.util.function.Function<D, K> key1, java.util.function.Function<D, K> key2, DiffFunction<K, D> insert, DiffFunction<K, D> update, DiffFunction<K, D> remove) {
        Map<Object, Object> map1 = list1 != null ? list1.stream().collect(Collectors.toMap(key1, e -> e)) : Collections.emptyMap();
        Map<Object, Object> map2 = list2 != null ? list2.stream().collect(Collectors.toMap(key2, e -> e)) : Collections.emptyMap();
        HashMap m_insert = new HashMap();
        HashMap m_update = new HashMap();
        HashMap m_remove = new HashMap();
        map1.forEach((k, v) -> {
            if (map2.containsKey(k)) {
                m_update.put(k, v);
            } else {
                m_insert.put(k, v);
            }
        });
        map2.forEach((k, v) -> {
            if (!map1.containsKey(k)) {
                m_remove.put(k, v);
            }
        });
        if (!m_insert.isEmpty()) {
            insert.apply(m_insert);
        }
        if (!m_update.isEmpty()) {
            update.apply(m_update);
        }
        if (!m_remove.isEmpty()) {
            remove.apply(m_remove);
        }
    }

    @FunctionalInterface
    public static interface DiffFunction<K, D> {
        public void apply(Map<K, D> var1);
    }

    @FunctionalInterface
    public static interface Function<T> {
        public void apply(T var1);
    }
}

