/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.security.validate;

import cn.nkpro.elcube.data.redis.RedisSupport;
import cn.nkpro.elcube.security.UserAccountService;
import cn.nkpro.elcube.security.bo.UserDetails;
import cn.nkpro.elcube.security.validate.NkUsernamePasswordVerCodeAuthentication;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class NkUsernamePasswordVerCodeAuthenticationProvider
implements AuthenticationProvider {
    private UserAccountService userDetailsService;
    private RedisSupport<Object> redisSupport;

    public NkUsernamePasswordVerCodeAuthenticationProvider(UserDetailsService userDetailsService, RedisSupport<Object> redisSupport) {
        this.userDetailsService = (UserAccountService)userDetailsService;
        this.redisSupport = redisSupport;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Object code;
        NkUsernamePasswordVerCodeAuthentication nkAuthentication = (NkUsernamePasswordVerCodeAuthentication)authentication;
        String key = "CACHE_AUTH_ERROR:" + nkAuthentication.getUsername();
        Integer s = (Integer)this.redisSupport.get(key);
        if (s != null) {
            if (s >= 5) {
                long increment = this.redisSupport.increment(key, 1L);
                long hour = (long)Math.pow(increment - 4L, 2.0);
                this.redisSupport.expire(key, 3600L * hour);
                throw new BadCredentialsException("\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7" + hour + "\u5c0f\u65f6\u540e\u518d\u8bd5");
            }
            code = this.redisSupport.get(nkAuthentication.getVerKey());
            if (code == null) {
                throw new BadCredentialsException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
            }
            if (!Objects.equals(code, nkAuthentication.getVerCode())) {
                throw new BadCredentialsException("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
            }
        }
        if ((code = this.redisSupport.get(nkAuthentication.getVerKey())) != null && !Objects.equals(code, nkAuthentication.getVerCode())) {
            throw new BadCredentialsException("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        UserDetails details = (UserDetails)this.userDetailsService.loadUserByUsername(nkAuthentication.getUsername());
        if (details == null) {
            throw new UsernameNotFoundException("\u8d26\u53f7\u6ca1\u6709\u627e\u5230");
        }
        if (details.getLocked() != null && details.getLocked() == 1) {
            throw new BadCredentialsException("\u8d26\u53f7\u5df2\u7981\u7528");
        }
        if (!StringUtils.equals((CharSequence)details.getPassword(), (CharSequence)nkAuthentication.getPassword())) {
            long increment = this.redisSupport.increment(key, 1L);
            if (increment >= 5L) {
                this.redisSupport.expire(key, 3600L);
                throw new BadCredentialsException("\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8fc7\u591a\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf71\u5c0f\u65f6\u540e\u518d\u8bd5");
            }
            this.redisSupport.expire(key, 300L * increment);
            throw new BadCredentialsException("\u5bc6\u7801\u9519\u8bef");
        }
        this.redisSupport.delete(key);
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)nkAuthentication.getPrincipal(), (Object)nkAuthentication.getCredentials(), details.getAuthorities());
        auth.setDetails((Object)details);
        return auth;
    }

    public boolean supports(Class<?> authentication) {
        return NkUsernamePasswordVerCodeAuthentication.class.isAssignableFrom(authentication);
    }
}

