/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.security.validate;

import cn.nkpro.elcube.security.validate.NkUsernamePasswordVerCodeAuthentication;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.filter.GenericFilterBean;

public class NkUsernamePasswordVerCodeAuthenticationFilter
extends GenericFilterBean {
    private static final Logger log = LoggerFactory.getLogger(NkUsernamePasswordVerCodeAuthenticationFilter.class);
    private AuthenticationManager authenticationManager;
    private AuthenticationEntryPoint authenticationEntryPoint;

    public NkUsernamePasswordVerCodeAuthenticationFilter(AuthenticationManager authenticationManager, AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationManager = authenticationManager;
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Authentication authentication;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse && ((authentication = SecurityContextHolder.getContext().getAuthentication()) == null || !authentication.isAuthenticated())) {
            String nkApp = StringUtils.defaultString((String)this.obtainParam(request, "NK-App"));
            String username = StringUtils.defaultString((String)this.obtainParam(request, "username"));
            String password = StringUtils.defaultString((String)this.obtainParam(request, "password"));
            String verKey = StringUtils.defaultString((String)this.obtainParam(request, "verKey"));
            String verCode = StringUtils.defaultString((String)this.obtainParam(request, "verCode"));
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nkApp, username, password})) {
                try {
                    Authentication responseAuthentication = this.authenticationManager.authenticate((Authentication)new NkUsernamePasswordVerCodeAuthentication(username, password, verKey, verCode));
                    if (responseAuthentication != null && responseAuthentication.isAuthenticated()) {
                        SecurityContextHolder.getContext().setAuthentication(responseAuthentication);
                    }
                }
                catch (AuthenticationException e) {
                    this.authenticationEntryPoint.commence((HttpServletRequest)request, (HttpServletResponse)response, e);
                    return;
                }
            }
        }
        filterChain.doFilter(request, response);
    }

    private String obtainParam(ServletRequest request, String param) {
        String token = ((HttpServletRequest)request).getHeader(param);
        if (Objects.isNull(token)) {
            token = request.getParameter(param);
        }
        return token;
    }
}

