/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.security.validate;

import cn.nkpro.elcube.data.redis.RedisSupport;
import cn.nkpro.elcube.security.UserAccountService;
import cn.nkpro.elcube.security.bo.UserDetails;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class NkUsernamePasswordAuthenticationProvider
implements AuthenticationProvider {
    private UserAccountService userDetailsService;
    private RedisSupport<Object> redisSupport;

    public NkUsernamePasswordAuthenticationProvider(UserAccountService userDetailsService, RedisSupport<Object> redisSupport) {
        this.userDetailsService = userDetailsService;
        this.redisSupport = redisSupport;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UsernamePasswordAuthenticationToken passwordAuthenticationToken = (UsernamePasswordAuthenticationToken)authentication;
        String key = "CACHE_AUTH_ERROR:" + passwordAuthenticationToken.getPrincipal();
        Integer s = (Integer)this.redisSupport.get(key);
        if (s != null && s >= 5) {
            long hour = this.redisSupport.getExpire(key);
            throw new BadCredentialsException("\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7" + (hour / 60L / 60L + 1L) + "\u5c0f\u65f6\u540e\u518d\u8bd5");
        }
        UserDetails details = this.userDetailsService.loadUserByUsernameFromCache((String)passwordAuthenticationToken.getPrincipal());
        if (details == null) {
            throw new BadCredentialsException("\u65e0\u6548\u7684\u8d26\u53f7\u4fe1\u606f");
        }
        if (details.getLocked() != null && details.getLocked() == 1) {
            throw new BadCredentialsException("\u8d26\u53f7\u5df2\u7981\u7528");
        }
        if (!StringUtils.equals((CharSequence)((CharSequence)passwordAuthenticationToken.getCredentials()), (CharSequence)details.getPassword())) {
            long increment = this.redisSupport.increment(key, 1L);
            if (increment >= 5L) {
                this.redisSupport.expire(key, 3600L);
                throw new BadCredentialsException("\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8fc7\u591a\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf71\u5c0f\u65f6\u540e\u518d\u8bd5");
            }
            this.redisSupport.expire(key, 300L * increment);
            throw new BadCredentialsException("\u65e0\u6548\u7684\u7528\u6237\u51ed\u8bc1");
        }
        passwordAuthenticationToken = new UsernamePasswordAuthenticationToken(passwordAuthenticationToken.getPrincipal(), passwordAuthenticationToken.getCredentials(), details.getAuthorities());
        passwordAuthenticationToken.setDetails((Object)details);
        return passwordAuthenticationToken;
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

