/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.security.validate;

import cn.nkpro.elcube.security.JwtHelper;
import io.jsonwebtoken.Claims;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.filter.GenericFilterBean;

public class NkTokenAuthenticationFilter
extends GenericFilterBean {
    private AuthenticationManager authenticationManager;
    private AuthenticationEntryPoint authenticationEntryPoint;

    public NkTokenAuthenticationFilter(AuthenticationManager authenticationManager, AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationManager = authenticationManager;
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            String tokenStr;
            String nkApp;
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if ((authentication == null || !authentication.isAuthenticated()) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{nkApp = StringUtils.defaultString((String)this.obtainParam(request, "NK-App")), tokenStr = this.obtainParam(request, "NK-Token")})) {
                Claims token = JwtHelper.verifyJwt(tokenStr);
                if (token == null) {
                    throw new BadCredentialsException("\u65e0\u6548\u7684token");
                }
                String username = (String)token.get("username", String.class);
                String password = (String)token.get("password", String.class);
                try {
                    Authentication responseAuthentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
                    if (responseAuthentication != null && responseAuthentication.isAuthenticated()) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("[" + responseAuthentication.getPrincipal() + "] successfully authenticated"));
                        }
                        SecurityContextHolder.getContext().setAuthentication(responseAuthentication);
                    }
                }
                catch (AuthenticationException e) {
                    this.authenticationEntryPoint.commence((HttpServletRequest)request, (HttpServletResponse)response, e);
                    return;
                }
            }
            filterChain.doFilter(request, response);
        }
    }

    private String obtainParam(ServletRequest request, String param) {
        String token = ((HttpServletRequest)request).getHeader(param);
        if (Objects.isNull(token)) {
            token = request.getParameter(param);
        }
        return token;
    }
}

