/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.security.impl;

import cn.nkpro.elcube.basic.GUID;
import cn.nkpro.elcube.co.spel.NkSpELManager;
import cn.nkpro.elcube.data.redis.RedisSupport;
import cn.nkpro.elcube.exception.NkDefineException;
import cn.nkpro.elcube.exception.NkInputFailedCaution;
import cn.nkpro.elcube.platform.DeployAble;
import cn.nkpro.elcube.platform.gen.UserAccount;
import cn.nkpro.elcube.platform.gen.UserAccountExample;
import cn.nkpro.elcube.platform.gen.UserAccountMapper;
import cn.nkpro.elcube.security.UserAuthorizationService;
import cn.nkpro.elcube.security.UserBusinessAdapter;
import cn.nkpro.elcube.security.bo.GrantedAuthority;
import cn.nkpro.elcube.security.bo.GrantedAuthoritySub;
import cn.nkpro.elcube.security.bo.UserGroupBO;
import cn.nkpro.elcube.security.gen.AuthGroup;
import cn.nkpro.elcube.security.gen.AuthGroupExample;
import cn.nkpro.elcube.security.gen.AuthGroupMapper;
import cn.nkpro.elcube.security.gen.AuthGroupRefExample;
import cn.nkpro.elcube.security.gen.AuthGroupRefKey;
import cn.nkpro.elcube.security.gen.AuthGroupRefMapper;
import cn.nkpro.elcube.security.gen.AuthLimit;
import cn.nkpro.elcube.security.gen.AuthLimitExample;
import cn.nkpro.elcube.security.gen.AuthLimitMapper;
import cn.nkpro.elcube.security.gen.AuthPermission;
import cn.nkpro.elcube.security.gen.AuthPermissionExample;
import cn.nkpro.elcube.security.gen.AuthPermissionMapper;
import cn.nkpro.elcube.utils.BeanUtilz;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Order(value=20)
@Service
public class UserAuthorizationServiceImpl
implements UserAuthorizationService,
DeployAble {
    private static final Logger log = LoggerFactory.getLogger(UserAuthorizationServiceImpl.class);
    @Autowired
    private GUID guid;
    @Autowired
    private AuthGroupMapper authGroupMapper;
    @Autowired
    private AuthGroupRefMapper authGroupRefMapper;
    @Autowired
    private AuthPermissionMapper authPermissionMapper;
    @Autowired
    private AuthLimitMapper authLimitMapper;
    @Autowired
    private UserAccountMapper accountMapper;
    @Autowired
    private RedisSupport<UserGroupBO> redisSupport;
    @Autowired
    private RedisSupport<AuthLimit> redisSupportLimit;
    @Autowired
    private NkSpELManager spELManager;
    @Autowired
    private UserBusinessAdapter userBusinessAdapter;

    @Override
    public List<GrantedAuthority> buildGrantedPerms(String accountId, String partnerId) {
        Object user = this.userBusinessAdapter.getUser(accountId);
        ArrayList permList = new ArrayList();
        AuthGroupRefExample authGroupRefExample = new AuthGroupRefExample();
        authGroupRefExample.createCriteria().andRefIdEqualTo(accountId).andRefTypeEqualTo(GROUP_TO_ACCOUNT);
        this.authGroupRefMapper.selectByExample(authGroupRefExample).forEach(ref -> {
            UserGroupBO group = this.buildUserGroup(ref.getGroupId());
            if (group != null && group.getAuthorities() != null) {
                permList.addAll(group.getAuthorities());
            }
        });
        HashSet limitIds = new HashSet();
        permList.forEach(grantedAuthority -> {
            if (grantedAuthority.getLimitIds() != null) {
                limitIds.addAll(Arrays.asList(grantedAuthority.getLimitIds()));
            }
        });
        Map<String, AuthLimit> limits = limitIds.stream().map(limitId -> this.redisSupportLimit.getIfAbsent("CACHE_AUTH_LIMIT", (String)limitId, () -> this.authLimitMapper.selectByPrimaryKey((String)limitId))).collect(Collectors.toMap(AuthLimit::getLimitId, v -> v));
        permList.forEach(authority -> {
            if (authority.getLimitIds() != null) {
                List query = Arrays.stream(authority.getLimitIds()).map(limits::get).filter(limit -> limit != null && limit.getContent() != null).map(AuthLimit::getContent).map(limit -> this.spELManager.convert((String)limit, user)).collect(Collectors.toList());
                if (query.size() > 1) {
                    authority.setLimitQuery(query.stream().collect(Collectors.joining(",", "{\"bool\":{\"must\":[", "]}}")));
                } else if (query.size() == 1) {
                    authority.setLimitQuery((String)query.get(0));
                }
            }
        });
        permList.forEach(perm -> permList.stream().filter(e -> StringUtils.equals((CharSequence)e.getAuthority(), (CharSequence)perm.getAuthority())).findFirst().ifPresent(first -> perm.setDisabled(perm != first)));
        return permList.stream().sorted().collect(Collectors.toList());
    }

    private UserGroupBO buildUserGroup(String groupId) {
        return this.redisSupport.getIfAbsent("CACHE_AUTH_GROUP", groupId, () -> {
            AuthGroup sysAuthGroup = this.authGroupMapper.selectByPrimaryKey(groupId);
            if (sysAuthGroup != null) {
                UserGroupBO g = BeanUtilz.copyFromObject((Object)sysAuthGroup, UserGroupBO.class);
                AuthGroupRefExample authGroupRefExample = new AuthGroupRefExample();
                authGroupRefExample.createCriteria().andGroupIdEqualTo(groupId).andRefTypeEqualTo(GROUP_TO_PERM);
                List permIds = this.authGroupRefMapper.selectByExample(authGroupRefExample).stream().map(AuthGroupRefKey::getRefId).collect(Collectors.toList());
                if (!permIds.isEmpty()) {
                    AuthPermissionExample authPermissionExample = new AuthPermissionExample();
                    authPermissionExample.createCriteria().andPermIdIn(permIds);
                    authPermissionExample.setOrderByClause("PERM_DESC");
                    g.setPermissions(this.authPermissionMapper.selectByExampleWithBLOBs(authPermissionExample));
                    ArrayList authoritys = new ArrayList();
                    g.getPermissions().forEach(permission -> {
                        if (StringUtils.startsWith((CharSequence)permission.getPermResource(), (CharSequence)"@") && StringUtils.containsAny((CharSequence)permission.getPermResource(), (char[])new char[]{'|', ','})) {
                            authoritys.addAll(Arrays.stream(permission.getPermResource().substring(1).split("[|,]")).map(resource -> this.buildAuthority(StringUtils.join((Object[])new String[]{"@", resource}), (AuthPermission)permission, g)).collect(Collectors.toList()));
                        } else {
                            authoritys.add(this.buildAuthority(permission.getPermResource(), (AuthPermission)permission, g));
                        }
                    });
                    g.setAuthorities(authoritys.stream().sorted().collect(Collectors.toList()));
                }
                return g;
            }
            return null;
        });
    }

    private GrantedAuthority buildAuthority(String resource, AuthPermission perm, AuthGroup group) {
        GrantedAuthority authority = new GrantedAuthority();
        authority.setPermResource(resource);
        authority.setPermOperate(perm.getPermOperate());
        authority.parseSubPerm(perm.getSubResource());
        authority.setLimitIds(StringUtils.split((String)perm.getLimitId(), (char)'|'));
        authority.setLevel(perm.getPermLevel());
        authority.setFromPermissionId(perm.getPermId());
        authority.setFromPermissionDesc(perm.getPermDesc());
        authority.setFromGroupId(group.getGroupId());
        authority.setFromGroupDesc(group.getGroupDesc());
        authority.setAuthority(String.format("%s:%s", authority.getPermResource(), authority.getPermOperate()));
        return authority;
    }

    @Override
    public List<AuthLimit> getLimits(String[] limitIds) {
        AuthLimitExample example = new AuthLimitExample();
        if (ArrayUtils.isNotEmpty((Object[])limitIds)) {
            example.createCriteria().andLimitIdIn((List)Arrays.asList(limitIds));
        }
        example.setOrderByClause("LIMIT_DESC");
        return this.authLimitMapper.selectByExample(example);
    }

    @Override
    public AuthLimit getLimitDetail(String limitId) {
        if (StringUtils.isNotBlank((CharSequence)limitId)) {
            return this.redisSupportLimit.getIfAbsent("CACHE_AUTH_LIMIT", limitId, () -> this.authLimitMapper.selectByPrimaryKey(limitId));
        }
        return null;
    }

    @Override
    public void updateLimit(AuthLimit limit) {
        Assert.hasText((String)limit.getLimitDesc(), (String)"\u9650\u5236\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            QueryBuilders.wrapperQuery((String)limit.getContent());
        }
        catch (IllegalArgumentException e) {
            throw new NkInputFailedCaution("\u9650\u5236\u89c4\u5219\u914d\u7f6e\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)limit.getLimitId())) {
            limit.setLimitId(this.guid.nextId(AuthLimit.class));
            this.authLimitMapper.insert(limit);
        } else {
            this.authLimitMapper.updateByPrimaryKeyWithBLOBs(limit);
            this.redisSupportLimit.deleteHash("CACHE_AUTH_LIMIT", limit.getLimitId());
        }
    }

    @Override
    public void removeLimit(String limitId) {
        this.authLimitMapper.deleteByPrimaryKey(limitId);
        this.redisSupportLimit.deleteHash("CACHE_AUTH_LIMIT", limitId);
    }

    @Override
    public List<AuthPermission> getPerms() {
        AuthPermissionExample example = new AuthPermissionExample();
        example.setOrderByClause("PERM_DESC");
        return this.authPermissionMapper.selectByExample(example);
    }

    @Override
    public AuthPermission getPermDetail(String permId) {
        return this.authPermissionMapper.selectByPrimaryKey(permId);
    }

    @Override
    public void updatePerm(AuthPermission perm) {
        Assert.hasText((String)perm.getPermDesc(), (String)"\u6743\u9650\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)perm.getPermResource(), (String)"\u6743\u9650\u8d44\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)perm.getPermOperate(), (String)"\u6743\u9650\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotBlank((CharSequence)perm.getSubResource())) {
            try {
                JSON.parseObject((String)perm.getSubResource(), GrantedAuthoritySub.class);
            }
            catch (Exception e) {
                throw new NkDefineException("\u64cd\u4f5c\u9650\u5236\u4e0d\u5408\u6cd5\uff1a" + e.getMessage());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)perm.getLimitId())) {
            perm.setLimitId(Arrays.stream(StringUtils.split((String)perm.getLimitId(), (char)'|')).sorted().collect(Collectors.joining("|")));
        }
        if (StringUtils.isBlank((CharSequence)perm.getPermId())) {
            perm.setPermId(this.guid.nextId(AuthPermission.class));
            this.authPermissionMapper.insert(perm);
        } else {
            this.authPermissionMapper.updateByPrimaryKeyWithBLOBs(perm);
            this.clearGroupByPerm(perm.getPermId());
        }
    }

    @Override
    public void removePerm(String permId) {
        Assert.isTrue((!permId.startsWith("nk-default-") ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u6743\u9650\u4e0d\u53ef\u79fb\u9664");
        this.authPermissionMapper.deleteByPrimaryKey(permId);
        this.clearGroupByPerm(permId);
    }

    private void clearGroupByPerm(String permId) {
        AuthGroupRefExample authGroupRefExample = new AuthGroupRefExample();
        authGroupRefExample.createCriteria().andRefIdEqualTo(permId).andRefTypeEqualTo(GROUP_TO_PERM);
        Object[] groupIds = this.authGroupRefMapper.selectByExample(authGroupRefExample).stream().map(AuthGroupRefKey::getGroupId).distinct().toArray(String[]::new);
        if (groupIds.length > 0) {
            this.redisSupport.deleteHash("CACHE_AUTH_GROUP", groupIds);
        }
    }

    @Override
    public List<AuthGroup> getGroups() {
        AuthGroupExample example = new AuthGroupExample();
        example.setOrderByClause("GROUP_DESC");
        return this.authGroupMapper.selectByExample(example);
    }

    @Override
    public List<UserGroupBO> getGroupBOs() {
        AuthGroupExample example = new AuthGroupExample();
        example.setOrderByClause("GROUP_DESC");
        return this.authGroupMapper.selectByExample(example).stream().map(g -> this.buildUserGroup(g.getGroupId())).collect(Collectors.toList());
    }

    @Override
    public UserGroupBO getGroupDetail(String groupId) {
        UserGroupBO group = this.buildUserGroup(groupId);
        AuthGroupRefExample authGroupRefExample = new AuthGroupRefExample();
        authGroupRefExample.createCriteria().andGroupIdEqualTo(groupId).andRefTypeEqualTo(GROUP_TO_ACCOUNT);
        List accountIds = this.authGroupRefMapper.selectByExample(authGroupRefExample).stream().map(AuthGroupRefKey::getRefId).collect(Collectors.toList());
        if (!accountIds.isEmpty()) {
            UserAccountExample accountExample = new UserAccountExample();
            accountExample.createCriteria().andIdIn(accountIds);
            accountExample.setOrderByClause("USERNAME");
            group.setAccounts(this.accountMapper.selectByExample(accountExample).stream().peek(a -> a.setPassword(null)).collect(Collectors.toList()));
        }
        return group;
    }

    @Override
    public void updateGroup(UserGroupBO group) {
        Assert.isTrue((StringUtils.isBlank((CharSequence)group.getGroupId()) || !group.getGroupId().startsWith("nk-default-") ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u7528\u6237\u7ec4\u4e0d\u53ef\u66f4\u65b0");
        Assert.hasText((String)group.getGroupDesc(), (String)"\u6743\u9650\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)group.getGroupId())) {
            group.setGroupId(this.guid.nextId(AuthGroup.class));
            this.authGroupMapper.insert(group);
        } else {
            this.authGroupMapper.updateByPrimaryKey(group);
            AuthGroupRefExample example = new AuthGroupRefExample();
            example.createCriteria().andGroupIdEqualTo(group.getGroupId()).andRefTypeEqualTo(GROUP_TO_PERM);
            this.authGroupRefMapper.deleteByExample(example);
        }
        if (group.getPermissions() != null) {
            group.getPermissions().forEach(perm -> {
                AuthGroupRefKey ref = new AuthGroupRefKey();
                ref.setGroupId(group.getGroupId());
                ref.setRefId(perm.getPermId());
                ref.setRefType(GROUP_TO_PERM);
                this.authGroupRefMapper.insert(ref);
            });
        }
        this.redisSupport.deleteHash("CACHE_AUTH_GROUP", group.getGroupId());
    }

    @Override
    public void removeGroup(String groupId) {
        Assert.isTrue((!groupId.startsWith("nk-default-") ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u7528\u6237\u7ec4\u4e0d\u53ef\u5220\u9664");
        AuthGroupRefExample example = new AuthGroupRefExample();
        example.createCriteria().andGroupIdEqualTo(groupId);
        this.authGroupRefMapper.deleteByExample(example);
        this.authGroupMapper.deleteByPrimaryKey(groupId);
        this.redisSupport.deleteHash("CACHE_AUTH_GROUP", groupId);
    }

    @Override
    public void removeAccountFromGroup(String groupId, String accountId) {
        Assert.isTrue((!groupId.startsWith("nk-default-") || !accountId.startsWith("nk-default-") ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u7528\u6237\u4e0d\u53ef\u79fb\u9664");
        AuthGroupRefExample example = new AuthGroupRefExample();
        example.createCriteria().andGroupIdEqualTo(groupId).andRefIdEqualTo(accountId).andRefTypeEqualTo(GROUP_TO_ACCOUNT);
        this.authGroupRefMapper.deleteByExample(example);
    }

    @Override
    public void addAccountFromGroup(String groupId, String accountId) {
        this.removeAccountFromGroup(groupId, accountId);
        AuthGroupRefKey ref = new AuthGroupRefKey();
        ref.setGroupId(groupId);
        ref.setRefId(accountId);
        ref.setRefType(GROUP_TO_ACCOUNT);
        this.authGroupRefMapper.insert(ref);
    }

    @Override
    public List<UserAccount> accounts(String keyword) {
        UserAccountExample example = new UserAccountExample();
        example.createCriteria().andUsernameLike(String.format("%%%s%%", keyword));
        return this.accountMapper.selectByExample(example, new RowBounds(0, 10)).stream().peek(a -> a.setPassword(null)).collect(Collectors.toList());
    }

    @Override
    public void loadExport(JSONArray exports) {
        JSONObject export = new JSONObject();
        export.put("key", (Object)"includeAuth");
        export.put("name", (Object)"\u7528\u6237\u7ec4\u4e0e\u6743\u9650");
        exports.add((Object)export);
    }

    @Override
    public void exportConfig(JSONObject config, JSONObject export) {
        if (config.getBooleanValue("includeAuth")) {
            export.put("groups", this.getGroupBOs().stream().filter(group -> !group.getGroupId().startsWith("nk-default-")).collect(Collectors.toList()));
            export.put("perms", this.getPerms());
            export.put("limits", this.getLimits(null).stream().map(limit -> this.getLimitDetail(limit.getLimitId())).collect(Collectors.toList()));
        }
    }

    @Override
    public void importConfig(JSONObject data) {
        if (data.containsKey((Object)"limits")) {
            data.getJSONArray("limits").toJavaList(AuthLimit.class).forEach(this::updateLimit);
        }
        if (data.containsKey((Object)"perms")) {
            data.getJSONArray("perms").toJavaList(AuthPermission.class).forEach(this::updatePerm);
        }
        if (data.containsKey((Object)"groups")) {
            data.getJSONArray("groups").toJavaList(UserGroupBO.class).stream().filter(group -> !group.getGroupId().startsWith("nk-default-")).forEach(this::updateGroup);
        }
    }
}

