/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.security.impl;

import cn.nkpro.elcube.basic.NkProperties;
import cn.nkpro.elcube.basic.PageList;
import cn.nkpro.elcube.data.mybatis.pagination.PaginationContext;
import cn.nkpro.elcube.data.redis.RedisSupport;
import cn.nkpro.elcube.platform.gen.UserAccount;
import cn.nkpro.elcube.platform.gen.UserAccountExample;
import cn.nkpro.elcube.platform.gen.UserAccountMapper;
import cn.nkpro.elcube.security.HashUtil;
import cn.nkpro.elcube.security.JwtHelper;
import cn.nkpro.elcube.security.UserAccountService;
import cn.nkpro.elcube.security.UserAuthorizationService;
import cn.nkpro.elcube.security.bo.UserAccountBO;
import cn.nkpro.elcube.security.bo.UserDetails;
import cn.nkpro.elcube.utils.BeanUtilz;
import cn.nkpro.elcube.utils.DateTimeUtilz;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component(value="NkSysAccountService")
public class UserAccountServiceImpl
implements UserAccountService {
    @Autowired
    private UserAccountMapper userAccountMapper;
    @Autowired
    private RedisSupport<UserAccount> redisTemplateAccount;
    @Autowired
    private RedisSupport<UserAccountBO> redisTemplate;
    @Autowired
    private NkProperties nkProperties;
    @Autowired
    private UserAuthorizationService authorizationService;

    @Override
    public UserAccount getAccountById(String id) {
        return StringUtils.isBlank((CharSequence)id) ? null : this.redisTemplateAccount.getIfAbsent("CACHE_SYS_ACCOUNT", id, () -> this.userAccountMapper.selectByPrimaryKey(id));
    }

    @Override
    public List<UserAccount> getAccountsByObjectId(List<String> docIds) {
        if (CollectionUtils.isEmpty(docIds)) {
            return Collections.emptyList();
        }
        UserAccountExample example = new UserAccountExample();
        example.createCriteria().andObjectIdIn((List)docIds);
        return this.userAccountMapper.selectByExample(example);
    }

    @Override
    public UserAccountBO getAccount(String username, boolean preClear) {
        if (preClear) {
            this.redisTemplate.deleteHash("CACHE_SYS_ACCOUNT", username);
        }
        return this.redisTemplate.getIfAbsent("CACHE_SYS_ACCOUNT", username, () -> this.getAccount(username));
    }

    private UserAccountBO getAccount(String username) {
        UserAccountExample example = new UserAccountExample();
        example.createCriteria().andUsernameEqualTo(username);
        return this.userAccountMapper.selectByExample(example).stream().findAny().map(sysAccount -> {
            UserAccountBO ud = BeanUtilz.copyFromObject(sysAccount, UserAccountBO.class);
            ud.setAuthorities(this.authorizationService.buildGrantedPerms(sysAccount.getId(), sysAccount.getObjectId()));
            return ud;
        }).orElse(null);
    }

    @Override
    public void clear() {
        this.redisTemplate.deleteHash("CACHE_SYS_ACCOUNT", SecurityContextHolder.getContext().getAuthentication().getPrincipal());
    }

    @Override
    public void checkPasswordStrategyAndSha1(UserAccount account) {
        Assert.notNull((Object)account.getPassword(), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotBlank((CharSequence)this.nkProperties.getPasswordStrategy())) {
            Assert.isTrue((boolean)Pattern.matches(this.nkProperties.getPasswordStrategy(), account.getPassword()), (String)"\u5bc6\u7801\u5f3a\u5ea6\u4e0d\u7b26\u5408\u8981\u6c42");
        }
        String password = account.getPassword();
        password = HashUtil.hash(password, "SHA1");
        password = HashUtil.hash(password, "SHA1");
        account.setPassword(password);
    }

    @Override
    public void doChangePassword(String accountId, String oldPassword, String newPassword) {
        UserAccount exists = this.userAccountMapper.selectByPrimaryKey(accountId);
        oldPassword = HashUtil.hash(oldPassword, "SHA1");
        oldPassword = HashUtil.hash(oldPassword, "SHA1");
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)exists.getPassword(), (CharSequence)oldPassword), (String)"\u539f\u59cb\u5bc6\u7801\u9519\u8bef");
        UserAccount account = new UserAccount();
        account.setId(accountId);
        account.setPassword(newPassword);
        this.checkPasswordStrategyAndSha1(account);
        account.setUpdatedTime(DateTimeUtilz.nowSeconds());
        this.userAccountMapper.updateByPrimaryKeySelective(account);
        this.redisTemplate.deleteHash("CACHE_SYS_ACCOUNT", exists.getUsername());
    }

    @Override
    public Map<String, Object> createToken() {
        String username = (String)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        UserAccountBO account = this.getAccount(username, false);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("username", username);
        map.put("password", account.getPassword());
        long time = 2700000L;
        long expire = 900000L;
        String token = JwtHelper.createJWT(map, time);
        HashMap<String, Object> tokenInfo = new HashMap<String, Object>();
        tokenInfo.put("accessToken", token);
        tokenInfo.put("expire", expire);
        tokenInfo.put("refresh", time);
        return tokenInfo;
    }

    @Override
    public Map<String, Object> refreshToken() {
        return this.createToken();
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        return Optional.ofNullable(this.getAccount(username, true)).map(account -> BeanUtilz.copyFromObject(account, UserDetails.class)).orElse(null);
    }

    @Override
    public UserDetails loadUserByUsernameFromCache(String username) throws UsernameNotFoundException {
        return Optional.ofNullable(this.getAccount(username, false)).map(account -> BeanUtilz.copyFromObject(account, UserDetails.class)).orElse(null);
    }

    @Override
    public PageList<UserAccount> accountsPage(Integer from, Integer size, String orderField, String order, String keyword) {
        PaginationContext context = PaginationContext.init();
        UserAccountExample example = new UserAccountExample();
        example.createCriteria().andUsernameLike(String.format("%%%s%%", keyword));
        if (StringUtils.isNotBlank((CharSequence)orderField)) {
            example.setOrderByClause(orderField + " " + (String)StringUtils.defaultIfBlank((CharSequence)order, (CharSequence)"ASC"));
        }
        return new PageList<UserAccount>(this.userAccountMapper.selectByExample(example, new RowBounds(0, 10)).stream().peek(a -> a.setPassword(null)).collect(Collectors.toList()), from, size, context.getTotal().intValue());
    }

    @Override
    public UserAccountBO update(UserAccountBO account) {
        if (StringUtils.isNotBlank((CharSequence)account.getId())) {
            UserAccount exists;
            if (StringUtils.isNotBlank((CharSequence)account.getPassword())) {
                this.checkPasswordStrategyAndSha1(account);
            }
            if (!StringUtils.equals((CharSequence)(exists = this.userAccountMapper.selectByPrimaryKey(account.getId())).getUsername(), (CharSequence)account.getUsername())) {
                UserAccountExample example = new UserAccountExample();
                example.createCriteria().andUsernameEqualTo(account.getUsername());
                Assert.isTrue((this.userAccountMapper.countByExample(example) == 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362");
            }
            account.setUpdatedTime(DateTimeUtilz.nowSeconds());
            this.userAccountMapper.updateByPrimaryKeySelective(account);
            this.redisTemplate.deleteHash("CACHE_SYS_ACCOUNT", exists.getUsername());
            this.redisTemplate.deleteHash("CACHE_SYS_ACCOUNT", account.getUsername());
        } else {
            this.checkPasswordStrategyAndSha1(account);
            UserAccountExample example = new UserAccountExample();
            example.createCriteria().andUsernameEqualTo(account.getUsername());
            Assert.isTrue((this.userAccountMapper.countByExample(example) == 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362");
            account.setId(UUID.randomUUID().toString());
            account.setLocked(0);
            account.setCreatedTime(DateTimeUtilz.nowSeconds());
            account.setUpdatedTime(DateTimeUtilz.nowSeconds());
            this.userAccountMapper.insert(account);
        }
        return account;
    }

    @Override
    public void clearLoginLock(UserAccountBO user) {
        this.redisTemplate.delete("CACHE_AUTH_ERROR:" + user.getUsername());
    }
}

