/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.security;

import cn.nkpro.elcube.exception.NkAccessDeniedException;
import cn.nkpro.elcube.security.bo.UserDetails;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Pattern;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityUtilz {
    public static UserDetails getUser() {
        return (UserDetails)Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(Authentication::getDetails).orElseThrow(() -> new NkAccessDeniedException("\u672a\u767b\u9646"));
    }

    private static Collection<? extends GrantedAuthority> getAuthorities() {
        return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(Authentication::getAuthorities).orElse(Collections.emptyList());
    }

    public static boolean hasAnyAuthority(String ... targetAuthoritys) {
        return targetAuthoritys.length == 0 || SecurityUtilz.getAuthorities().stream().anyMatch(authority -> {
            Pattern pattern = Pattern.compile(String.format("^%s$", authority.getAuthority().replaceAll("[*]", "[@#]?[A-Za-z0-9_-]+")));
            return Arrays.stream(targetAuthoritys).anyMatch(targetAuthority -> pattern.matcher(targetAuthority.toUpperCase()).matches());
        });
    }
}

