/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.security;

import cn.nkpro.elcube.data.redis.RedisSupport;
import cn.nkpro.elcube.security.NkAccessDeniedHandler;
import cn.nkpro.elcube.security.NkAuthenticationEntryPoint;
import cn.nkpro.elcube.security.UserAccountService;
import cn.nkpro.elcube.security.UserBusinessAdapter;
import cn.nkpro.elcube.security.validate.NkTokenAuthenticationFilter;
import cn.nkpro.elcube.security.validate.NkUsernamePasswordAuthenticationProvider;
import cn.nkpro.elcube.security.validate.NkUsernamePasswordVerCodeAuthenticationFilter;
import cn.nkpro.elcube.security.validate.NkUsernamePasswordVerCodeAuthenticationProvider;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

@Configuration
@EnableGlobalMethodSecurity(securedEnabled=true, prePostEnabled=true)
public class NkWebSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private UserAccountService userDetailsService;
    @Autowired
    private RedisSupport<Object> redisSupport;
    private NkAuthenticationEntryPoint nkAuthenticationEntryPoint = new NkAuthenticationEntryPoint();

    @Bean(name={"org.springframework.security.authenticationManager"})
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    protected void configure(AuthenticationManagerBuilder auth) {
        auth.authenticationProvider((AuthenticationProvider)new NkUsernamePasswordAuthenticationProvider(this.userDetailsService, this.redisSupport));
        auth.authenticationProvider((AuthenticationProvider)new NkUsernamePasswordVerCodeAuthenticationProvider(this.userDetailsService, this.redisSupport));
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).headers().frameOptions().sameOrigin().and()).addFilterBefore((Filter)new NkTokenAuthenticationFilter(this.authenticationManager(), this.nkAuthenticationEntryPoint), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)new BasicAuthenticationFilter(this.authenticationManager(), (AuthenticationEntryPoint)this.nkAuthenticationEntryPoint), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)new NkUsernamePasswordVerCodeAuthenticationFilter(this.authenticationManager(), this.nkAuthenticationEntryPoint), UsernamePasswordAuthenticationFilter.class).exceptionHandling().accessDeniedHandler((AccessDeniedHandler)new NkAccessDeniedHandler()).authenticationEntryPoint((AuthenticationEntryPoint)this.nkAuthenticationEntryPoint).and();
    }

    @ConditionalOnMissingBean
    @Bean
    protected UserBusinessAdapter userBusinessAdapter() {
        return new UserBusinessAdapter(){};
    }
}

