/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.security;

import cn.nkpro.elcube.security.bo.GrantedAuthority;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Component;

@Component
public class NkSecurityRunner {
    @Qualifier(value="NkSysAccountService")
    @Autowired
    private UserDetailsService userDetailsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAsUser(String username, Function function) {
        UserDetails details = this.userDetailsService.loadUserByUsername(username);
        GrantedAuthority authority = new GrantedAuthority();
        authority.setAuthority("*:*");
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)username, null, Collections.singletonList(authority));
        authentication.setDetails((Object)details);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        try {
            function.apply();
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    @FunctionalInterface
    public static interface Function {
        public void apply();
    }
}

