/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.security;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class JwtHelper {
    private static final long TOKEN_EXPIRED_TIME = 864000000L;
    private static final long TOKEN_RENEW_TIME = 432000000L;
    private static final long TOKEN_EXPIRED_TIME_WEBL = 3600000L;
    private static final long TOKEN_RENEW_TIME_WEB = 1800000L;
    private static final String JWT_SECRET = "MDk4ZjZiY2Q0NjIxZDM3M2NhZGU0ZTgzMjYyN2I0ZjY=";
    private static final String jwtId = "tokenId";

    public static String createJWT(Map<String, Object> claims, Long time) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        Date now = new Date(System.currentTimeMillis());
        SecretKey secretKey = JwtHelper.generalKey();
        long nowMillis = System.currentTimeMillis();
        JwtBuilder builder = Jwts.builder().setClaims(claims).setId(jwtId).setIssuedAt(now).signWith(signatureAlgorithm, (Key)secretKey);
        if (time >= 0L) {
            long expMillis = nowMillis + time;
            Date exp = new Date(expMillis);
            builder.setExpiration(exp);
        }
        return builder.compact();
    }

    public static Claims verifyJwt(String token) {
        Claims claims;
        SecretKey key = JwtHelper.generalKey();
        try {
            claims = (Claims)Jwts.parser().setSigningKey((Key)key).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            claims = null;
        }
        return claims;
    }

    private static SecretKey generalKey() {
        byte[] encodedKey = Base64.getDecoder().decode(JWT_SECRET);
        return new SecretKeySpec(encodedKey, 0, encodedKey.length, "AES");
    }

    private static Map<String, Object> generateTokenData(String unionId, String userId, String phone, String systemId, String accountName, String deviceId, Integer deviceType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("unionId", unionId);
        map.put("accountId", userId);
        map.put("accountPhone", phone);
        map.put("systemId", systemId);
        map.put("accountName", accountName);
        map.put("deviceId", deviceId);
        map.put("deviceType", deviceType);
        return map;
    }
}

