/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.platform.service.impl;

import cn.nkpro.elcube.data.redis.RedisSupport;
import cn.nkpro.elcube.platform.DeployAble;
import cn.nkpro.elcube.platform.gen.PlatformMenu;
import cn.nkpro.elcube.platform.gen.PlatformMenuExample;
import cn.nkpro.elcube.platform.gen.PlatformMenuMapper;
import cn.nkpro.elcube.platform.model.WebMenuBO;
import cn.nkpro.elcube.platform.service.WebMenuService;
import cn.nkpro.elcube.security.SecurityUtilz;
import cn.nkpro.elcube.utils.BeanUtilz;
import cn.nkpro.elcube.utils.DateTimeUtilz;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Order(value=10)
@Service
public class WebMenuServiceImpl
implements WebMenuService,
DeployAble,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(WebMenuServiceImpl.class);
    @Autowired
    private PlatformMenuMapper sysWebappMenuMapper;
    @Autowired
    private RedisSupport<List<WebMenuBO>> redisSupport;

    @Override
    public List<WebMenuBO> getMenus(boolean filterAuth) {
        List menus = this.redisSupport.getIfAbsent("CACHE_NAV_MENUS", () -> {
            PlatformMenuExample example = new PlatformMenuExample();
            example.setOrderByClause("ORDER_BY");
            List ret = this.sysWebappMenuMapper.selectByExample(example).stream().map(m -> BeanUtilz.copyFromObject(m, WebMenuBO.class)).collect(Collectors.toList());
            ret.stream().filter(m -> StringUtils.isNotBlank((CharSequence)m.getParentId())).forEach(m -> ret.stream().filter(p -> StringUtils.equals((CharSequence)p.getMenuId(), (CharSequence)m.getParentId())).findAny().ifPresent(p -> {
                if (p.getChildren() == null) {
                    p.setChildren(new ArrayList<PlatformMenu>());
                }
                p.getChildren().add((PlatformMenu)m);
            }));
            ret.removeIf(sysWebappMenuBO -> StringUtils.isNotBlank((CharSequence)sysWebappMenuBO.getParentId()));
            return ret;
        });
        if (filterAuth) {
            menus.forEach(menu -> {
                if (menu.getChildren() != null) {
                    menu.getChildren().removeIf(sub -> !StringUtils.isBlank((CharSequence)sub.getAuthorityOptions()) && !SecurityUtilz.hasAnyAuthority(sub.getAuthorityOptions().split("[|,]")));
                }
            });
            menus.removeIf(menu -> menu.getChildren() != null && menu.getChildren().isEmpty() || !StringUtils.isBlank((CharSequence)menu.getAuthorityOptions()) && !SecurityUtilz.hasAnyAuthority(menu.getAuthorityOptions().split("[|,]")));
        }
        return menus;
    }

    @Override
    public PlatformMenu getDetail(String id) {
        return this.sysWebappMenuMapper.selectByPrimaryKey(id);
    }

    @Override
    @Transactional
    public void doUpdate(List<WebMenuBO> menus) {
        Long updateTime = DateTimeUtilz.nowSeconds();
        menus.forEach(menu -> {
            menu.setParentId(null);
            menu.setOrderBy((menus.indexOf(menu) + 1) * 10000);
            menu.setMenuId((String)StringUtils.defaultIfBlank((CharSequence)menu.getMenuId(), (CharSequence)UUID.randomUUID().toString()));
            this.update((PlatformMenu)menu, updateTime);
            if (menu.getChildren() != null) {
                menu.getChildren().forEach(m -> {
                    m.setParentId(menu.getMenuId());
                    m.setMenuId((String)StringUtils.defaultIfBlank((CharSequence)m.getMenuId(), (CharSequence)UUID.randomUUID().toString()));
                    m.setOrderBy(menu.getOrderBy() + menu.getChildren().indexOf(m));
                    this.update((PlatformMenu)m, updateTime);
                });
            }
        });
        PlatformMenuExample example = new PlatformMenuExample();
        example.createCriteria().andUpdatedTimeLessThan(updateTime);
        this.sysWebappMenuMapper.deleteByExample(example);
        this.redisSupport.delete("CACHE_NAV_MENUS");
    }

    private void update(PlatformMenu menu, Long updateTime) {
        menu.setUpdatedTime(updateTime);
        if (this.sysWebappMenuMapper.selectByPrimaryKey(menu.getMenuId()) == null) {
            this.sysWebappMenuMapper.insert(menu);
        } else if (menu.getMenuOptions() == null) {
            this.sysWebappMenuMapper.updateByPrimaryKey(menu);
        } else {
            this.sysWebappMenuMapper.updateByPrimaryKeyWithBLOBs(menu);
        }
    }

    public void afterPropertiesSet() {
        this.redisSupport.delete("CACHE_NAV_MENUS");
    }

    @Override
    public void loadExport(JSONArray exports) {
        JSONObject export = new JSONObject();
        export.put("key", (Object)"includeMenu");
        export.put("name", (Object)"\u4e3b\u83dc\u5355");
        exports.add((Object)export);
    }

    @Override
    public void exportConfig(JSONObject config, JSONObject export) {
        if (config.getBooleanValue("includeMenu")) {
            export.put("menus", this.getMenus(false));
        }
    }

    @Override
    public void importConfig(JSONObject data) {
        if (data.containsKey((Object)"menus")) {
            this.doUpdate(data.getJSONArray("menus").toJavaList(WebMenuBO.class));
        }
    }
}

