/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.platform.service.impl;

import cn.nkpro.elcube.basic.GUID;
import cn.nkpro.elcube.platform.gen.UserSavedQuery;
import cn.nkpro.elcube.platform.gen.UserSavedQueryExample;
import cn.nkpro.elcube.platform.gen.UserSavedQueryMapper;
import cn.nkpro.elcube.platform.service.UserQueryService;
import cn.nkpro.elcube.security.SecurityUtilz;
import cn.nkpro.elcube.security.bo.UserDetails;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserQueryServiceImpl
implements UserQueryService {
    @Autowired
    private GUID guid;
    @Autowired
    private UserSavedQueryMapper queryMapper;

    @Override
    public List<UserSavedQuery> getList(String source) {
        UserDetails user = SecurityUtilz.getUser();
        UserSavedQueryExample example = new UserSavedQueryExample();
        example.createCriteria().andSourceEqualTo(source).andUserIdEqualTo(user.getId());
        example.setOrderByClause("NAME");
        return this.queryMapper.selectByExampleWithBLOBs(example);
    }

    @Override
    public void create(UserSavedQuery query) {
        UserDetails user = SecurityUtilz.getUser();
        query.setId(this.guid.nextId(UserSavedQuery.class));
        query.setUserId(user.getId());
        this.queryMapper.insertSelective(query);
    }

    @Override
    public void delete(String queryId) {
        this.queryMapper.deleteByPrimaryKey(queryId);
    }
}

