/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.platform.service.impl;

import cn.nkpro.elcube.annotation.Keep;
import cn.nkpro.elcube.basic.TransactionSync;
import cn.nkpro.elcube.data.redis.RedisSupport;
import cn.nkpro.elcube.platform.DeployAble;
import cn.nkpro.elcube.platform.gen.PlatformRegistry;
import cn.nkpro.elcube.platform.gen.PlatformRegistryExample;
import cn.nkpro.elcube.platform.gen.PlatformRegistryKey;
import cn.nkpro.elcube.platform.gen.PlatformRegistryMapper;
import cn.nkpro.elcube.platform.service.PlatformRegistryService;
import cn.nkpro.elcube.utils.BeanUtilz;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=0)
@Service
public class PlatformRegistryServiceImpl
implements PlatformRegistryService,
DeployAble {
    @Autowired
    private PlatformRegistryMapper constantMapper;
    @Autowired
    private RedisSupport<PlatformRegistry> redisSupport;

    @Override
    public List<PlatformRegistry> getAllByType(String type) {
        PlatformRegistryExample example = new PlatformRegistryExample();
        if (StringUtils.isNotBlank((CharSequence)type)) {
            example.createCriteria().andRegTypeEqualTo(type);
        }
        example.setOrderByClause("REG_TYPE,ORDER_BY");
        return this.constantMapper.selectByExampleWithBLOBs(example);
    }

    private PlatformRegistry getFromCache(String regType, String regKey) {
        return this.redisSupport.getIfAbsent("CACHE_DEF_CONSTANT", String.format("%s.%s", regType, regKey), () -> {
            PlatformRegistryKey pk = new PlatformRegistryKey();
            pk.setRegType(regType);
            pk.setRegKey(regKey);
            return this.constantMapper.selectByPrimaryKey(pk);
        });
    }

    @Override
    public Object getJSON(String regType, String regKey) {
        PlatformRegistry registry = this.getFromCache(regType, regKey);
        if (registry != null) {
            return JSON.parse((String)registry.getContent());
        }
        return null;
    }

    @Override
    public String getString(String regType, String regKey) {
        PlatformRegistry registry = this.getFromCache(regType, regKey);
        if (registry != null) {
            return registry.getContent();
        }
        return null;
    }

    @Override
    public List<Object> getList(String regType, String regKeyPrefix) {
        PlatformRegistryExample example = new PlatformRegistryExample();
        PlatformRegistryExample.Criteria criteria = example.createCriteria().andRegTypeEqualTo(regType);
        if (!StringUtils.equals((CharSequence)regKeyPrefix, (CharSequence)"@")) {
            criteria.andRegKeyLike(regKeyPrefix + "%");
        }
        example.setOrderByClause("ORDER_BY");
        return this.constantMapper.selectByExampleWithBLOBs(example).stream().map(item -> JSON.parse((String)item.getContent())).collect(Collectors.toList());
    }

    @Override
    public PlatformRegistry getValue(String key) {
        String regType = StringUtils.substringBefore((String)key, (String)".");
        String regKey = StringUtils.substringAfter((String)key, (String)".");
        return this.getFromCache(regType, regKey);
    }

    @Override
    public void updateValue(PlatformRegistry registry) {
        if (this.constantMapper.selectByPrimaryKey(registry) == null) {
            registry.setOrderBy(0);
            this.constantMapper.insert(registry);
        } else {
            this.constantMapper.updateByPrimaryKeyWithBLOBs(registry);
            TransactionSync.runAfterCommit("redis", () -> this.redisSupport.deleteHash("CACHE_DEF_CONSTANT", String.format("%s.%s", registry.getRegType(), registry.getRegKey())));
        }
    }

    @Override
    public void deleteValue(PlatformRegistry registry) {
        this.constantMapper.deleteByPrimaryKey(registry);
        TransactionSync.runAfterCommit("redis", () -> this.redisSupport.deleteHash("CACHE_DEF_CONSTANT", String.format("%s.%s", registry.getRegType(), registry.getRegKey())));
    }

    @Override
    public List<TreeNode> getTree() {
        PlatformRegistryExample example = new PlatformRegistryExample();
        example.setOrderByClause("REG_KEY");
        LinkedHashMap<String, TreeNode> cache = new LinkedHashMap<String, TreeNode>();
        ArrayList<TreeNode> tree = new ArrayList<TreeNode>();
        TreeNode meter = new TreeNode("@METER", null, "METER|\u8868\u76d8");
        TreeNode dict = new TreeNode("@DICT", null, "DICT|\u5b57\u5178");
        TreeNode note = new TreeNode("@DATASET", null, "DATASET|\u6570\u636e\u96c6");
        TreeNode page = new TreeNode("@PAGE", null, "PAGE|\u9875\u9762");
        cache.put(meter.getKey(), meter);
        tree.add(meter);
        cache.put(dict.getKey(), dict);
        tree.add(dict);
        cache.put(note.getKey(), note);
        tree.add(note);
        cache.put(page.getKey(), page);
        tree.add(page);
        this.constantMapper.selectByExample(example).forEach(registry -> {
            TreeNode parentNode = this.findParent(cache, null, registry.getRegType(), registry.getRegKey().split("[.]"), 0);
            TreeNode node = new TreeNode((PlatformRegistry)registry);
            parentNode.getChildren().add(node);
            cache.put(node.getKey(), node);
        });
        return tree;
    }

    private TreeNode findParent(Map<String, TreeNode> cache, TreeNode parent, String type, String[] splitKeys, int level) {
        String key = Arrays.stream(splitKeys).limit(level).collect(Collectors.joining("."));
        String parentKey = type + (StringUtils.isBlank((CharSequence)key) ? "" : ".") + key;
        TreeNode parentNode = cache.computeIfAbsent(parentKey, k -> {
            TreeNode node = new TreeNode(type, key, null);
            if (parent != null) {
                parent.getChildren().add(node);
            }
            return node;
        });
        if (parentNode.getChildren() == null) {
            parentNode.setChildren(new ArrayList<TreeNode>());
            parentNode.setIsLeaf(false);
        }
        if (level < splitKeys.length - 1) {
            parentNode = this.findParent(cache, parentNode, type, splitKeys, ++level);
        }
        return parentNode;
    }

    @Override
    public void loadExport(JSONArray exports) {
        JSONObject export = new JSONObject();
        export.put("key", (Object)"includeRegistry");
        export.put("name", (Object)"\u57fa\u7840\u914d\u7f6e");
        exports.add((Object)export);
    }

    @Override
    public void exportConfig(JSONObject config, JSONObject export) {
        if (config.getBooleanValue("includeRegistry")) {
            export.put("registries", this.getAllByType(null));
        }
    }

    @Override
    public void importConfig(JSONObject data) {
        if (data.containsKey((Object)"registries")) {
            this.doUpdate(data.getJSONArray("registries").toJavaList(PlatformRegistry.class));
        }
    }

    @Override
    public void doUpdate(List<PlatformRegistry> list) {
        this.constantMapper.deleteByExample(null);
        list.forEach(defConstant -> this.constantMapper.insert((PlatformRegistry)defConstant));
        this.redisSupport.delete("CACHE_DEF_CONSTANT");
    }

    @Keep
    public static class TreeNode
    extends PlatformRegistry {
        private String key;
        private String title;
        private Boolean isLeaf;
        private List<TreeNode> children;

        TreeNode(String type, String key, String title) {
            this.key = type + (StringUtils.isBlank((CharSequence)key) ? "" : ".") + StringUtils.defaultString((String)key);
            this.setRegType(type);
            this.setRegKey(key);
            this.title = StringUtils.defaultString((String)title, (String)StringUtils.substringAfterLast((String)this.key, (String)"."));
        }

        TreeNode(PlatformRegistry registry) {
            this.key = registry.getRegType() + '.' + registry.getRegKey();
            this.title = registry.getTitle();
            this.isLeaf = true;
            BeanUtilz.copyFromObject((Object)registry, this);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TreeNode)) {
                return false;
            }
            TreeNode other = (TreeNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            Boolean this$isLeaf = this.getIsLeaf();
            Boolean other$isLeaf = other.getIsLeaf();
            if (this$isLeaf == null ? other$isLeaf != null : !((Object)this$isLeaf).equals(other$isLeaf)) {
                return false;
            }
            List<TreeNode> this$children = this.getChildren();
            List<TreeNode> other$children = other.getChildren();
            return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TreeNode;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            Boolean $isLeaf = this.getIsLeaf();
            result = result * 59 + ($isLeaf == null ? 43 : ((Object)$isLeaf).hashCode());
            List<TreeNode> $children = this.getChildren();
            result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
            return result;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        public Boolean getIsLeaf() {
            return this.isLeaf;
        }

        public List<TreeNode> getChildren() {
            return this.children;
        }

        public void setKey(String key) {
            this.key = key;
        }

        @Override
        public void setTitle(String title) {
            this.title = title;
        }

        public void setIsLeaf(Boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public void setChildren(List<TreeNode> children) {
            this.children = children;
        }

        public String toString() {
            return "PlatformRegistryServiceImpl.TreeNode(key=" + this.getKey() + ", title=" + this.getTitle() + ", isLeaf=" + this.getIsLeaf() + ", children=" + this.getChildren() + ")";
        }
    }
}

