/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.platform.service.impl;

import cn.nkpro.elcube.basic.NkProperties;
import cn.nkpro.elcube.basic.PageList;
import cn.nkpro.elcube.co.DebugContextManager;
import cn.nkpro.elcube.co.NkCustomObject;
import cn.nkpro.elcube.co.NkCustomObjectManager;
import cn.nkpro.elcube.co.NkCustomScriptObject;
import cn.nkpro.elcube.co.NkScriptV;
import cn.nkpro.elcube.data.mybatis.pagination.PaginationContext;
import cn.nkpro.elcube.data.redis.RedisSupport;
import cn.nkpro.elcube.exception.NkDefineException;
import cn.nkpro.elcube.platform.DeployAble;
import cn.nkpro.elcube.platform.gen.PlatformScript;
import cn.nkpro.elcube.platform.gen.PlatformScriptExample;
import cn.nkpro.elcube.platform.gen.PlatformScriptKey;
import cn.nkpro.elcube.platform.gen.PlatformScriptMapper;
import cn.nkpro.elcube.platform.gen.PlatformScriptWithBLOBs;
import cn.nkpro.elcube.platform.model.NkHeartbeatEvent;
import cn.nkpro.elcube.platform.service.NkScriptManager;
import cn.nkpro.elcube.utils.BeanUtilz;
import cn.nkpro.elcube.utils.DateTimeUtilz;
import cn.nkpro.elcube.utils.TextUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Order(value=30)
@Service
public class NkScriptManagerImpl
implements NkScriptManager,
DeployAble {
    private static final Logger log = LoggerFactory.getLogger(NkScriptManagerImpl.class);
    @Autowired
    private RedisSupport<List<PlatformScriptWithBLOBs>> redisSupport;
    @Autowired
    private RedisSupport<String> redisSupportString;
    @Autowired
    private PlatformScriptMapper scriptDefHMapper;
    @Autowired
    private NkCustomObjectManager customObjectManager;
    @Autowired
    private DebugContextManager debugContextManager;
    @Autowired
    private NkProperties nkProperties;
    private String scriptRandom;

    @Override
    public PageList<PlatformScript> getPage(String keyword, String type, String version, String state, int from, int rows, String orderField, String order) {
        PlatformScriptExample example = new PlatformScriptExample();
        example.createCriteria();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            example.getOredCriteria().forEach(criteria -> criteria.andScriptNameLike(String.format("%%%s%%", keyword)));
            example.or().andScriptDescLike(String.format("%%%s%%", keyword));
        }
        if (StringUtils.isNotBlank((CharSequence)type)) {
            example.getOredCriteria().forEach(criteria -> criteria.andScriptTypeEqualTo(type));
        }
        if (StringUtils.isNotBlank((CharSequence)version)) {
            example.getOredCriteria().forEach(criteria -> criteria.andVersionLike(String.format("%%%s%%", version)));
        }
        if (StringUtils.isNotBlank((CharSequence)state)) {
            example.getOredCriteria().forEach(criteria -> criteria.andStateEqualTo(state));
        }
        if (StringUtils.isNotBlank((CharSequence)orderField)) {
            example.setOrderByClause(String.format("%s %s", orderField, order));
        } else {
            example.setOrderByClause("SCRIPT_NAME");
        }
        PaginationContext context = PaginationContext.init();
        List<PlatformScript> list = this.scriptDefHMapper.selectByExample(example, new RowBounds(from, rows));
        return new PageList<PlatformScript>(list, from, rows, context.getTotal().intValue());
    }

    @Override
    public List<PlatformScriptWithBLOBs> getActiveResources() {
        return this.redisSupport.getIfAbsent("CACHE_DEF_SCRIPT", () -> {
            PlatformScriptExample example = new PlatformScriptExample();
            example.createCriteria().andStateEqualTo("Active");
            return this.scriptDefHMapper.selectByExampleWithBLOBs(example);
        });
    }

    @Override
    public PlatformScript getScript(String scriptName, String version) {
        NkCustomObject customObject = this.customObjectManager.getCustomObjectIfExists(scriptName, NkCustomObject.class);
        if (customObject instanceof NkCustomScriptObject && StringUtils.equalsAny((CharSequence)version, (CharSequence[])new CharSequence[]{((NkCustomScriptObject)customObject).getScriptDef().getVersion()})) {
            return ((NkCustomScriptObject)customObject).getScriptDef();
        }
        PlatformScriptKey key = new PlatformScriptKey();
        key.setScriptName(scriptName);
        key.setVersion(version);
        return Optional.ofNullable(this.scriptDefHMapper.selectByPrimaryKey(key)).orElseThrow(() -> new NkDefineException("\u914d\u7f6e\u6ca1\u6709\u627e\u5230"));
    }

    @Override
    @Transactional
    public PlatformScript doRun(NkScriptV scriptDefH, boolean run) {
        if (run) {
            Assert.isTrue((!StringUtils.equals((CharSequence)scriptDefH.getVersion(), (CharSequence)"@") ? 1 : 0) != 0, (String)"IDE\u7248\u672c\u4e0d\u80fd\u8c03\u8bd5");
            Assert.isTrue((boolean)StringUtils.equals((CharSequence)scriptDefH.getState(), (CharSequence)"InActive"), (String)"\u5df2\u6fc0\u6d3b\u7684\u7248\u672c\u4e0d\u80fd\u8c03\u8bd5");
            this.doUpdate(scriptDefH, false);
            this.debugContextManager.addDebugResource("#" + scriptDefH.getScriptName(), scriptDefH);
        } else {
            this.debugContextManager.removeDebugResource("#" + scriptDefH.getScriptName(), scriptDefH);
        }
        return scriptDefH;
    }

    @Override
    @Transactional
    public PlatformScript doBreach(NkScriptV scriptDefH) {
        scriptDefH.setState("InActive");
        scriptDefH.setVersion(UUID.randomUUID().toString());
        scriptDefH.setCreatedTime(DateTimeUtilz.nowSeconds());
        scriptDefH.setUpdatedTime(DateTimeUtilz.nowSeconds());
        this.doUpdate(scriptDefH, false);
        return scriptDefH;
    }

    @Override
    @Transactional
    public PlatformScript doUpdate(NkScriptV scriptDefH, boolean force) {
        scriptDefH.setState((String)StringUtils.defaultIfBlank((CharSequence)scriptDefH.getState(), (CharSequence)"InActive"));
        scriptDefH.setUpdatedTime(DateTimeUtilz.nowSeconds());
        if (this.scriptDefHMapper.selectByPrimaryKey(scriptDefH) == null) {
            this.scriptDefHMapper.insertSelective(scriptDefH);
        } else {
            this.scriptDefHMapper.updateByPrimaryKeySelective(scriptDefH);
        }
        return scriptDefH;
    }

    @Override
    @Transactional
    public PlatformScript doActive(NkScriptV scriptDefH, boolean force) {
        if (!force) {
            Assert.isTrue((!this.nkProperties.isComponentReloadClassPath() ? 1 : 0) != 0, (String)"IDE\u6a21\u5f0f\u4e0d\u80fd\u6fc0\u6d3b\u811a\u672c");
            Assert.isTrue((!StringUtils.equals((CharSequence)scriptDefH.getVersion(), (CharSequence)"@") ? 1 : 0) != 0, (String)"IDE\u7248\u672c\u4e0d\u80fd\u6fc0\u6d3b");
            Assert.isTrue((!StringUtils.equals((CharSequence)scriptDefH.getState(), (CharSequence)"Active") ? 1 : 0) != 0, (String)"\u5df2\u6fc0\u6d3b\u7684\u7248\u672c\u4e0d\u80fd\u6fc0\u6d3b");
        }
        PlatformScriptWithBLOBs record = new PlatformScriptWithBLOBs();
        record.setState("History");
        PlatformScriptExample example = new PlatformScriptExample();
        example.createCriteria().andScriptNameEqualTo(scriptDefH.getScriptName()).andStateEqualTo("Active");
        this.scriptDefHMapper.updateByExampleSelective(record, example);
        scriptDefH.setState("Active");
        StringBuilder groovy = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)scriptDefH.getGroovyMain())) {
            groovy.append(scriptDefH.getGroovyMain());
        }
        if (StringUtils.isNotBlank((CharSequence)scriptDefH.getGroovyRefs())) {
            groovy.append(scriptDefH.getGroovyRefs());
        }
        scriptDefH.setGroovyMd5(TextUtils.md5(groovy.toString()));
        this.doUpdate(scriptDefH, force);
        this.debugContextManager.addActiveResource("#" + scriptDefH.getScriptName(), scriptDefH, true);
        this.scriptRandom = UUID.randomUUID().toString();
        this.redisSupportString.set("CACHE_DEF_SCRIPT_RANDOM", this.scriptRandom);
        this.redisSupportString.delete("CACHE_DEF_SCRIPT");
        return scriptDefH;
    }

    @Override
    @Transactional
    public void doDelete(NkScriptV scriptDefH) {
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)scriptDefH.getState(), (CharSequence)"InActive"), (String)"\u975e\u672a\u6fc0\u6d3b\u7684\u7248\u672c\u4e0d\u80fd\u5220\u9664");
        this.scriptDefHMapper.deleteByPrimaryKey(scriptDefH);
        this.debugContextManager.removeDebugResource("#" + scriptDefH.getScriptName(), scriptDefH);
    }

    public void onApplicationEvent(@NotNull ApplicationEvent event) {
        String scriptRandom;
        if (event instanceof ContextRefreshedEvent && ((ContextRefreshedEvent)event).getApplicationContext() == this.debugContextManager.getApplicationContext()) {
            this.getActiveResources().forEach(scriptDef -> {
                try {
                    this.debugContextManager.addActiveResource("#" + scriptDef.getScriptName(), BeanUtilz.copyFromObject(scriptDef, NkScriptV.class), !this.nkProperties.isComponentReloadClassPath());
                }
                catch (RuntimeException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            });
        }
        if (event instanceof NkHeartbeatEvent && !this.nkProperties.isComponentReloadClassPath() && !StringUtils.equals((CharSequence)this.scriptRandom, (CharSequence)(scriptRandom = this.redisSupportString.get("CACHE_DEF_SCRIPT_RANDOM")))) {
            this.getActiveResources().forEach(scriptDef -> {
                String oMd5;
                NkCustomScriptObject object = this.customObjectManager.getCustomObject(scriptDef.getScriptName(), NkCustomScriptObject.class);
                String nMd5 = scriptDef.getGroovyMd5();
                if (!StringUtils.equals((CharSequence)nMd5, (CharSequence)(oMd5 = object.getScriptDef().getGroovyMd5()))) {
                    log.info("\u811a\u672c {} \u53d1\u751f\u6539\u53d8, \u7acb\u5373\u91cd\u65b0\u8f7d\u5165", (Object)scriptDef.getScriptName());
                    try {
                        this.debugContextManager.addActiveResource("#" + scriptDef.getScriptName(), BeanUtilz.copyFromObject(scriptDef, NkScriptV.class), true);
                    }
                    catch (RuntimeException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
            this.scriptRandom = scriptRandom;
        }
    }

    @Override
    public void loadExport(JSONArray exports) {
        JSONObject export = new JSONObject();
        export.put("key", (Object)"scripts");
        export.put("name", (Object)"\u7ec4\u4ef6\u5bf9\u8c61");
        export.put("list", this.customObjectManager.getCustomObjectDescriptionList(NkCustomScriptObject.class, false, entry -> {
            NkCustomScriptObject value = (NkCustomScriptObject)entry.getValue();
            return value.getScriptDef() != null && !StringUtils.equals((CharSequence)value.getScriptDef().getState(), (CharSequence)"Native");
        }));
        exports.add((Object)export);
    }

    @Override
    public void exportConfig(JSONObject config, JSONObject export) {
        if (config.getJSONArray("scripts") != null) {
            export.put("scripts", config.getJSONArray("scripts").stream().map(beanName -> this.customObjectManager.getCustomObject((String)beanName, NkCustomScriptObject.class).getScriptDef()).collect(Collectors.toList()));
        }
    }

    @Override
    public void importConfig(JSONObject data) {
        if (data.containsKey((Object)"scripts")) {
            data.getJSONArray("scripts").toJavaList(NkScriptV.class).forEach(scriptV -> this.doActive((NkScriptV)scriptV, true));
        }
    }
}

