/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.platform.service;

import cn.nkpro.elcube.co.NkCustomObjectManager;
import cn.nkpro.elcube.co.meter.NkMeter;
import cn.nkpro.elcube.platform.service.PlatformRegistryService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MeterService {
    @Autowired
    private NkCustomObjectManager customObjectManager;
    @Autowired
    private PlatformRegistryService registryService;

    public List<JSONObject> getCardDefs() {
        return this.customObjectManager.getCustomObjects(NkMeter.class).entrySet().stream().map(entry -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("component", entry.getKey());
            jsonObject.put("name", (Object)((NkMeter)entry.getValue()).getName());
            jsonObject.put("w", (Object)((NkMeter)entry.getValue()).getW());
            jsonObject.put("h", (Object)((NkMeter)entry.getValue()).getH());
            return jsonObject;
        }).collect(Collectors.toList());
    }

    public List<JSONObject> getCardList() {
        List<JSONObject> collect = this.getCardDefs();
        collect.addAll(this.registryService.getAllByType("@METER").stream().map(registry -> {
            String meterType = registry.getDataType();
            JSONObject jsonObject = collect.stream().filter(m -> StringUtils.equals((CharSequence)m.getString("component"), (CharSequence)meterType)).findFirst().orElse(null);
            if (jsonObject != null) {
                JSONObject config = JSON.parseObject((String)registry.getContent());
                JSONObject clone = (JSONObject)jsonObject.clone();
                clone.put("config", (Object)config);
                clone.put("name", (Object)registry.getTitle());
                return clone;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        return collect;
    }

    public Object getCardData(String meterName, Object config) {
        return this.customObjectManager.getCustomObject(meterName, NkMeter.class).getData(config);
    }
}

