/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.platform.service;

import cn.nkpro.elcube.platform.gen.UserDashboard;
import cn.nkpro.elcube.platform.gen.UserDashboardMapper;
import cn.nkpro.elcube.platform.gen.UserDashboardRef;
import cn.nkpro.elcube.platform.gen.UserDashboardRefExample;
import cn.nkpro.elcube.platform.gen.UserDashboardRefKey;
import cn.nkpro.elcube.platform.gen.UserDashboardRefMapper;
import cn.nkpro.elcube.platform.model.SysUserDashboardBO;
import cn.nkpro.elcube.security.SecurityUtilz;
import cn.nkpro.elcube.utils.DateTimeUtilz;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DashboardService {
    @Autowired
    private UserDashboardMapper userDashboardMapper;
    @Autowired
    private UserDashboardRefMapper userDashboardRefMapper;

    public SysUserDashboardBO loadUserDashboards(String dashboardId) {
        SysUserDashboardBO board = new SysUserDashboardBO();
        UserDashboardRefExample example = new UserDashboardRefExample();
        example.createCriteria().andAccountIdEqualTo(SecurityUtilz.getUser().getId());
        example.setOrderByClause("ORDER_BY");
        board.setRefs(this.userDashboardRefMapper.selectByExample(example));
        if (!board.getRefs().isEmpty()) {
            board.setActiveDashboard(this.userDashboardMapper.selectByPrimaryKey((String)StringUtils.defaultIfBlank((CharSequence)dashboardId, (CharSequence)board.getRefs().get(0).getId())));
        }
        return board;
    }

    @Transactional
    public void doUpdateRefs(List<UserDashboardRef> refs) {
        UserDashboardRefExample example = new UserDashboardRefExample();
        example.createCriteria().andAccountIdEqualTo(SecurityUtilz.getUser().getId());
        List<UserDashboardRef> exists = this.userDashboardRefMapper.selectByExample(example);
        refs.forEach(item -> {
            if (StringUtils.isBlank((CharSequence)item.getId())) {
                item.setId(UUID.randomUUID().toString());
                item.setOrderBy(refs.indexOf(item));
                item.setAccountId(SecurityUtilz.getUser().getId());
                this.userDashboardRefMapper.insert((UserDashboardRef)item);
                UserDashboard dashboard = new UserDashboard();
                dashboard.setId(item.getId());
                dashboard.setName(item.getName());
                dashboard.setAccountId(SecurityUtilz.getUser().getId());
                dashboard.setUpdatedTime(DateTimeUtilz.nowSeconds());
                this.userDashboardMapper.insert(dashboard);
            } else {
                exists.stream().filter(e -> StringUtils.equals((CharSequence)e.getId(), (CharSequence)item.getId())).findFirst().ifPresent(exists::remove);
                item.setOrderBy(refs.indexOf(item));
                this.userDashboardRefMapper.updateByPrimaryKey((UserDashboardRef)item);
            }
        });
        exists.forEach(item -> {
            this.userDashboardRefMapper.deleteByPrimaryKey((UserDashboardRefKey)item);
            this.userDashboardMapper.deleteByPrimaryKey(item.getId());
        });
    }

    @Transactional
    public void doUpdate(UserDashboard dashboard) {
        if (StringUtils.isBlank((CharSequence)dashboard.getId())) {
            dashboard.setId(UUID.randomUUID().toString());
            dashboard.setAccountId(SecurityUtilz.getUser().getId());
            this.userDashboardMapper.insert(dashboard);
            UserDashboardRef ref = new UserDashboardRef();
            ref.setAccountId(SecurityUtilz.getUser().getId());
            ref.setId(dashboard.getId());
            ref.setOrderBy(0);
            ref.setName(dashboard.getName());
            this.userDashboardRefMapper.insert(ref);
        } else {
            this.userDashboardMapper.updateByPrimaryKeyWithBLOBs(dashboard);
        }
    }

    @Transactional
    public void doDel(String dashboardId) {
        UserDashboardRefExample example = new UserDashboardRefExample();
        example.createCriteria().andIdEqualTo(dashboardId);
        this.userDashboardRefMapper.deleteByExample(example);
        this.userDashboardMapper.deleteByPrimaryKey(dashboardId);
    }
}

