/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.platform.controller;

import cn.nkpro.elcube.annotation.NkNote;
import cn.nkpro.elcube.data.redis.RedisSupport;
import com.google.code.kaptcha.Producer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ver"})
public class UserAuthVerCodeController {
    @Autowired
    private Producer kaptcha;
    @Autowired
    private RedisSupport<String> redisSupport;
    @Autowired
    private RedisSupport<Integer> redisSupportInteger;

    @NkNote(value="\u68c0\u67e5\u662f\u5426\u9700\u8981\u9a8c\u8bc1\u7801")
    @RequestMapping(value={"/has/{username}"})
    public Map<String, Object> verCode(@PathVariable(value="username") String username) {
        String key = "CACHE_AUTH_ERROR:" + username;
        Integer count = this.redisSupportInteger.get(key);
        Long time = this.redisSupport.getExpire(key);
        String message = null;
        if (count != null && count >= 5) {
            message = "\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7" + ((int)(time / 60L / 60L) + 1) + "\u5c0f\u65f6\u540e\u518d\u8bd5";
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("count", count);
        ret.put("message", message);
        return ret;
    }

    @NkNote(value="\u767b\u9646\u9a8c\u8bc1\u7801")
    @RequestMapping(value={"/code/{random}"}, produces={"image/png"})
    public byte[] verCode(HttpServletResponse response, @PathVariable(value="random") String random) throws IOException {
        response.setHeader("Cache-Control", "no-store, no-cache");
        response.setContentType("image/jpeg");
        String text = this.kaptcha.createText();
        BufferedImage image = this.kaptcha.createImage(text);
        this.redisSupport.set(random, text);
        this.redisSupport.expire(random, 600L);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", out);
        out.flush();
        out.close();
        return out.toByteArray();
    }
}

