/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.platform.controller;

import cn.nkpro.elcube.annotation.NkNote;
import cn.nkpro.elcube.security.SecurityUtilz;
import cn.nkpro.elcube.security.UserAccountService;
import cn.nkpro.elcube.security.UserAuthorizationService;
import cn.nkpro.elcube.security.bo.UserDetails;
import cn.nkpro.elcube.security.gen.AuthLimit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@PreAuthorize(value="authenticated")
@NkNote(value="2.\u7528\u6237\u9a8c\u8bc1\u670d\u52a1")
@RestController
@RequestMapping(value={"/authentication"})
public class UserAuthController {
    @Qualifier(value="NkSysAccountService")
    @Autowired
    private UserAccountService tfmsSysAccountService;
    @Autowired
    private UserAuthorizationService permService;

    @PreAuthorize(value="hasAnyAuthority('*:*','SYS:LOGIN')")
    @NkNote(value="1.\u83b7\u53d6token\u767b\u9646")
    @RequestMapping(value={"/token"})
    public Map<String, Object> token() {
        return this.tfmsSysAccountService.createToken();
    }

    @NkNote(value="2.\u5237\u65b0token")
    @RequestMapping(value={"/refresh_token"})
    public Map<String, Object> refreshToken() {
        return this.tfmsSysAccountService.refreshToken();
    }

    @NkNote(value="3.\u6e05\u9664token\u5e76\u9000\u51fa")
    @RequestMapping(value={"/clear"})
    public void clear() {
        this.tfmsSysAccountService.clear();
    }

    @NkNote(value="4.\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @RequestMapping(value={"/info"})
    public UserDetails info() {
        UserDetails user = SecurityUtilz.getUser();
        user.setPassword(null);
        return user;
    }

    @NkNote(value="5.\u83b7\u53d6\u7528\u6237\u6388\u6743\u9650\u5236")
    @RequestMapping(value={"/info/limits"})
    public List<AuthLimit> limits(@RequestBody String[] limitIds) {
        if (ArrayUtils.isEmpty((Object[])limitIds)) {
            return Collections.emptyList();
        }
        return this.permService.getLimits(limitIds);
    }

    @NkNote(value="6.\u4fee\u6539\u5bc6\u7801")
    @RequestMapping(value={"/change_password"})
    public void changePassword(@RequestParam(value="oldPassword") String oldPassword, @RequestParam(value="newPassword") String newPassword) {
        this.tfmsSysAccountService.doChangePassword(SecurityUtilz.getUser().getId(), oldPassword, newPassword);
    }
}

