/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.platform.controller;

import cn.nkpro.elcube.annotation.NkNote;
import cn.nkpro.elcube.basic.NkProperties;
import cn.nkpro.elcube.platform.gen.UserSavedQuery;
import cn.nkpro.elcube.platform.model.WebMenuBO;
import cn.nkpro.elcube.platform.service.PlatformRegistryService;
import cn.nkpro.elcube.platform.service.UserQueryService;
import cn.nkpro.elcube.platform.service.WebMenuService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@NkNote(value="1.UI\u63a7\u5236\u5668")
@RequestMapping(value={"/webapp"})
@RestController
public class UserAppController {
    @Autowired
    private NkProperties properties;
    @Autowired
    private WebMenuService menuService;
    @Autowired
    private UserQueryService userQueryService;
    @Autowired
    private PlatformRegistryService constantService;

    @NkNote(value="1.\u83b7\u53d6\u73af\u5883\u540d\u79f0")
    @RequestMapping(value={"/env"})
    public String env() {
        return this.properties.getEnvName();
    }

    @PreAuthorize(value="authenticated")
    @NkNote(value="2.\u52a0\u8f7dWeb\u4e3b\u83dc\u5355")
    @RequestMapping(value={"/menus"})
    public List<WebMenuBO> menus() {
        return this.menuService.getMenus(true);
    }

    @PreAuthorize(value="authenticated")
    @NkNote(value="3.\u52a0\u8f7d\u83dc\u5355\u8be6\u60c5")
    @RequestMapping(value={"/menu/{id}"})
    public String menus(@PathVariable(value="id") String id) {
        return this.constantService.getString("@PAGE", id);
    }

    @PreAuthorize(value="authenticated")
    @NkNote(value="31\u3001\u83b7\u53d6\u4fdd\u5b58\u7684\u641c\u7d22\u5217\u8868")
    @RequestMapping(value={"/user/saved/query/list"})
    public List<UserSavedQuery> getList(String source) {
        return this.userQueryService.getList(source);
    }

    @PreAuthorize(value="authenticated")
    @NkNote(value="32\u3001\u4fdd\u5b58\u7684\u641c\u7d22\u6761\u4ef6")
    @RequestMapping(value={"/user/saved/query/create"})
    public UserSavedQuery create(@RequestBody UserSavedQuery query) {
        this.userQueryService.create(query);
        return query;
    }

    @PreAuthorize(value="authenticated")
    @NkNote(value="33\u3001\u5220\u9664\u5df2\u4fdd\u5b58\u7684\u641c\u7d22\u6761\u4ef6")
    @RequestMapping(value={"/user/saved/query/delete"})
    public void delete(String queryId) {
        this.userQueryService.delete(queryId);
    }
}

