/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.platform.controller;

import cn.nkpro.elcube.annotation.NkNote;
import cn.nkpro.elcube.basic.PageList;
import cn.nkpro.elcube.platform.gen.UserAccount;
import cn.nkpro.elcube.security.UserAccountService;
import cn.nkpro.elcube.security.UserAuthorizationService;
import cn.nkpro.elcube.security.bo.UserAccountBO;
import cn.nkpro.elcube.security.bo.UserGroupBO;
import cn.nkpro.elcube.security.gen.AuthGroup;
import cn.nkpro.elcube.security.gen.AuthLimit;
import cn.nkpro.elcube.security.gen.AuthPermission;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NkNote(value="12.\u6743\u9650\u8bbe\u7f6e")
@RestController
@RequestMapping(value={"/settings/auth"})
@PreAuthorize(value="hasAnyAuthority('*:*','SETTINGS:*','SETTINGS:AUTH')")
public class SettingsAuthController {
    @Autowired
    private UserAuthorizationService permService;
    @Autowired
    private UserAccountService accountService;

    @RequestMapping(value={"/limit/list"})
    public List<AuthLimit> limits() {
        return this.permService.getLimits(null);
    }

    @RequestMapping(value={"/limit/detail"})
    public AuthLimit limitDetail(String limitId) {
        return this.permService.getLimitDetail(limitId);
    }

    @RequestMapping(value={"/limit/update"})
    public AuthLimit limitUpdate(@RequestBody AuthLimit limit) {
        this.permService.updateLimit(limit);
        return limit;
    }

    @RequestMapping(value={"/limit/remove"})
    public void limitRemove(String limitId) {
        this.permService.removeLimit(limitId);
    }

    @RequestMapping(value={"/perm/list"})
    public List<AuthPermission> perms() {
        return this.permService.getPerms();
    }

    @RequestMapping(value={"/perm/detail"})
    public AuthPermission permDetail(String permId) {
        return this.permService.getPermDetail(permId);
    }

    @RequestMapping(value={"/perm/update"})
    public AuthPermission permUpdate(@RequestBody AuthPermission perm) {
        this.permService.updatePerm(perm);
        return perm;
    }

    @RequestMapping(value={"/perm/remove"})
    public void permRemove(String permId) {
        this.permService.removePerm(permId);
    }

    @RequestMapping(value={"/group/list"})
    public List<AuthGroup> groups() {
        return this.permService.getGroups();
    }

    @RequestMapping(value={"/group/detail"})
    public AuthGroup groupDetail(String groupId) {
        return this.permService.getGroupDetail(groupId);
    }

    @RequestMapping(value={"/group/update"})
    public UserGroupBO groupUpdate(@RequestBody UserGroupBO group) {
        this.permService.updateGroup(group);
        return this.permService.getGroupDetail(group.getGroupId());
    }

    @RequestMapping(value={"/group/remove"})
    public void groupRemove(String groupId) {
        this.permService.removeGroup(groupId);
    }

    @RequestMapping(value={"/group/remove/account"})
    public AuthGroup groupRemoveAccount(String groupId, String accountId) {
        this.permService.removeAccountFromGroup(groupId, accountId);
        return this.permService.getGroupDetail(groupId);
    }

    @RequestMapping(value={"/group/add/account"})
    public AuthGroup groupAddAccount(String groupId, String accountId) {
        this.permService.addAccountFromGroup(groupId, accountId);
        return this.permService.getGroupDetail(groupId);
    }

    @RequestMapping(value={"/accounts/list"})
    public PageList<UserAccount> accountsList(@RequestParam(value="from", required=false, defaultValue="0") Integer from, @RequestParam(value="rows", required=false, defaultValue="10") Integer rows, @RequestParam(value="orderField", required=false) String orderField, @RequestParam(value="order", required=false) String order, @RequestParam(value="keyword", required=false, defaultValue="") String keyword) {
        return this.accountService.accountsPage(from, rows, orderField, order, keyword);
    }

    @RequestMapping(value={"/accounts/detail"})
    public UserAccountBO accountsDetail(@RequestParam(value="username") String username) {
        UserAccountBO account = this.accountService.getAccount(username, false);
        account.setPassword(null);
        return account;
    }

    @RequestMapping(value={"/accounts/update"})
    public UserAccountBO accountsUpdate(@RequestBody UserAccountBO user) {
        return this.accountService.update(user);
    }

    @RequestMapping(value={"/accounts/clearLoginLock"})
    public void clearLoginLock(@RequestBody UserAccountBO user) {
        this.accountService.clearLoginLock(user);
    }

    @RequestMapping(value={"/accounts"})
    public List<UserAccount> accounts(String keyword) {
        return this.permService.accounts(keyword);
    }
}

