/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.platform.controller;

import cn.nkpro.elcube.annotation.Keep;
import cn.nkpro.elcube.annotation.NkNote;
import cn.nkpro.elcube.co.NkCustomObject;
import cn.nkpro.elcube.co.NkCustomObjectManager;
import cn.nkpro.elcube.co.NkCustomScriptObject;
import cn.nkpro.elcube.co.NkScriptComponent;
import cn.nkpro.elcube.co.NkScriptV;
import cn.nkpro.elcube.exception.NkSystemException;
import groovy.lang.GroovyObject;
import java.util.HashMap;
import java.util.Map;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@NkNote(value="35.[DevDef]\u811a\u672c\u8d44\u6e90")
@RestController
@RequestMapping(value={"/def/resources"})
public class ScriptResController {
    @Autowired
    private NkCustomObjectManager customObjectManager;

    @NkNote(value="1.\u83b7\u53d6\u5361\u7247\u4fe1\u606f")
    @RequestMapping(value={"/vue"})
    public Map<Object, Object> vueTemplates() {
        HashMap<Object, Object> vueMap = new HashMap<Object, Object>();
        this.customObjectManager.getCustomObjects(NkScriptComponent.class).values().forEach(nkCard -> vueMap.putAll(nkCard.getVueTemplate()));
        return vueMap;
    }

    @NkNote(value="5.\u83b7\u53d6\u811a\u672c\u7684Groovy\u7c7b\u540d")
    @RequestMapping(value={"/bean/{beanName}"})
    public BeanDescribe className(@PathVariable(value="beanName") String beanName) {
        NkScriptV scriptDef;
        Object customObject = this.customObjectManager.getCustomObjectIfExists(beanName, NkCustomObject.class);
        if (customObject == null) {
            return new BeanDescribe(null, false, "@", "NotFound", false);
        }
        if (customObject instanceof NkCustomScriptObject && (scriptDef = ((NkCustomScriptObject)customObject).getScriptDef()) != null) {
            return new BeanDescribe(scriptDef.getScriptName(), customObject instanceof GroovyObject, scriptDef.getVersion(), scriptDef.getState(), scriptDef.isDebug());
        }
        customObject = this.getTargetBean(customObject);
        return new BeanDescribe(customObject.getClass().getSimpleName(), customObject instanceof GroovyObject, "@", "Native", false);
    }

    private Object getTargetBean(Object bean) {
        if (AopUtils.isAopProxy((Object)bean)) {
            try {
                bean = ((Advised)bean).getTargetSource().getTarget();
            }
            catch (Exception e) {
                throw new NkSystemException(e.getMessage(), (Throwable)e);
            }
        }
        return bean;
    }

    @Keep
    public static class BeanDescribe {
        String className;
        boolean isGroovy;
        String version;
        String state;
        boolean debug;

        public String getClassName() {
            return this.className;
        }

        public boolean isGroovy() {
            return this.isGroovy;
        }

        public String getVersion() {
            return this.version;
        }

        public String getState() {
            return this.state;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setGroovy(boolean isGroovy) {
            this.isGroovy = isGroovy;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setState(String state) {
            this.state = state;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BeanDescribe)) {
                return false;
            }
            BeanDescribe other = (BeanDescribe)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            if (this.isGroovy() != other.isGroovy()) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$state = this.getState();
            String other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            return this.isDebug() == other.isDebug();
        }

        protected boolean canEqual(Object other) {
            return other instanceof BeanDescribe;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            result = result * 59 + (this.isGroovy() ? 79 : 97);
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            result = result * 59 + (this.isDebug() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "ScriptResController.BeanDescribe(className=" + this.getClassName() + ", isGroovy=" + this.isGroovy() + ", version=" + this.getVersion() + ", state=" + this.getState() + ", debug=" + this.isDebug() + ")";
        }

        public BeanDescribe(String className, boolean isGroovy, String version, String state, boolean debug) {
            this.className = className;
            this.isGroovy = isGroovy;
            this.version = version;
            this.state = state;
            this.debug = debug;
        }
    }
}

