/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.platform.controller;

import cn.nkpro.elcube.annotation.NkNote;
import cn.nkpro.elcube.basic.NkProperties;
import cn.nkpro.elcube.basic.PageList;
import cn.nkpro.elcube.co.NkCustomObjectManager;
import cn.nkpro.elcube.co.NkScriptV;
import cn.nkpro.elcube.platform.gen.PlatformScript;
import cn.nkpro.elcube.platform.service.NkScriptManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@NkNote(value="34.[DevDef]\u811a\u672c\u914d\u7f6e")
@RestController
@RequestMapping(value={"/def/script"})
@PreAuthorize(value="hasAnyAuthority('*:*','DEF:*','DEF:COMPONENT')")
public class ScriptController {
    @Autowired
    private NkCustomObjectManager customObjectManager;
    @Autowired
    private NkScriptManager scriptService;
    @Autowired
    private NkProperties properties;

    @NkNote(value="1\u3001\u83b7\u53d6\u811a\u672c\u5217\u8868")
    @RequestMapping(value={"/page"})
    public PageList<PlatformScript> page(@NkNote(value="\u67e5\u8be2\u5173\u952e\u5b57") @RequestParam(value="keyword", required=false) String keyword, @NkNote(value="\u5206\u7c7b") @RequestParam(value="type", required=false) String type, @NkNote(value="\u7248\u672c") @RequestParam(value="version", required=false) String version, @NkNote(value="\u72b6\u6001") @RequestParam(value="state", required=false) String state, @NkNote(value="\u8d77\u59cb\u6761\u76ee") @RequestParam(value="from", defaultValue="0") Integer from, @NkNote(value="\u6761\u76ee\u6570") @RequestParam(value="rows", defaultValue="10") Integer rows, @NkNote(value="\u6392\u5e8f\u5b57\u6bb5") @RequestParam(value="orderField", defaultValue="") String orderField, @NkNote(value="\u6392\u5e8f\u65b9\u5f0f") @RequestParam(value="order", defaultValue="") String order) {
        return this.scriptService.getPage(keyword, type, version, state, from, rows, orderField, order);
    }

    @NkNote(value="2\u3001\u901a\u8fc7\u811a\u672cID\u83b7\u53d6\u811a\u672c")
    @RequestMapping(value={"/detail/{script}/{version}"})
    public PlatformScript detail(@PathVariable(value="script") String scriptName, @PathVariable String version) {
        return this.scriptService.getScript(scriptName, version);
    }

    @NkNote(value="4.\u590d\u5236")
    @RequestMapping(value={"/breach"})
    public PlatformScript breach(@NkNote(value="\u811a\u672c\u5bf9\u8c61") @RequestBody NkScriptV script) {
        return this.scriptService.doBreach(script);
    }

    @NkNote(value="5.\u66f4\u65b0")
    @RequestMapping(value={"/update"})
    public PlatformScript update(@NkNote(value="\u811a\u672c\u5bf9\u8c61") @RequestBody NkScriptV script) {
        return this.scriptService.doUpdate(script, false);
    }

    @NkNote(value="6.\u6fc0\u6d3b")
    @RequestMapping(value={"/active"})
    public PlatformScript active(@NkNote(value="\u811a\u672c\u5bf9\u8c61") @RequestBody NkScriptV script, @RequestParam(value="force", defaultValue="false", required=false) Boolean force) {
        return this.scriptService.doActive(script, force);
    }

    @NkNote(value="7.\u5220\u9664")
    @RequestMapping(value={"/delete"})
    public void delete(@NkNote(value="\u811a\u672c\u5bf9\u8c61") @RequestBody NkScriptV script) {
        this.scriptService.doDelete(script);
    }

    @NkNote(value="8.\u8c03\u8bd5")
    @RequestMapping(value={"/debug"})
    public PlatformScript debug(@NkNote(value="\u811a\u672c\u5bf9\u8c61") @RequestBody NkScriptV script, @RequestParam(value="run") boolean run) {
        return this.scriptService.doRun(script, run);
    }

    @NkNote(value="10.\u662f\u5426\u7981\u7528\u5728\u7ebf\u7f16\u8f91")
    @RequestMapping(value={"/online/editing"})
    public boolean isComponentDisableOnlineEditing() {
        return this.properties.isComponentDisableOnlineEditing();
    }
}

