/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.platform.controller;

import cn.nkpro.elcube.annotation.NkNote;
import cn.nkpro.elcube.platform.gen.PlatformRegistry;
import cn.nkpro.elcube.platform.service.PlatformRegistryService;
import cn.nkpro.elcube.platform.service.impl.PlatformRegistryServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@NkNote(value="32.[DevDef]\u5e38\u91cf")
@RequestMapping(value={"/platform/registry/def"})
@RestController
@PreAuthorize(value="hasAnyAuthority('*:*','DEF:*','DEF:REGISTRY')")
public class RegistryDefController {
    @Autowired
    private PlatformRegistryService constantService;

    @NkNote(value="11\u3001\u52a0\u8f7d\u5e38\u91cf\u5217\u8868")
    @RequestMapping(value={"/tree"})
    public List<PlatformRegistryServiceImpl.TreeNode> tree() {
        return this.constantService.getTree();
    }

    @NkNote(value="11\u3001\u52a0\u8f7d\u5e38\u91cf\u5217\u8868")
    @RequestMapping(value={"/value/{key}"}, method={RequestMethod.GET})
    public PlatformRegistry value(@PathVariable(value="key") String key) {
        return this.constantService.getValue(key);
    }

    @NkNote(value="11\u3001\u52a0\u8f7d\u5e38\u91cf\u5217\u8868")
    @RequestMapping(value={"/value"}, method={RequestMethod.POST})
    public void post(@RequestBody PlatformRegistry registry) {
        this.constantService.updateValue(registry);
    }

    @NkNote(value="11\u3001\u52a0\u8f7d\u5e38\u91cf\u5217\u8868")
    @RequestMapping(value={"/value/delete"}, method={RequestMethod.POST})
    public void delete(@RequestBody PlatformRegistry registry) {
        this.constantService.deleteValue(registry);
    }

    @NkNote(value="12\u3001\u66f4\u65b0")
    @RequestMapping(value={"/save"})
    public void save(@RequestBody List<PlatformRegistry> list) {
        this.constantService.doUpdate(list);
    }
}

