/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.platform.controller;

import cn.nkpro.elcube.annotation.NkNote;
import cn.nkpro.elcube.co.fs.FSConfig;
import cn.nkpro.elcube.co.fs.FSSupport;
import cn.nkpro.elcube.co.fs.FileUploadStatus;
import cn.nkpro.elcube.co.fs.defaults.DefaultFileSupportImpl;
import java.io.File;
import javax.naming.OperationNotSupportedException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.HandlerMapping;

@NkNote(value="5.\u6587\u4ef6\u7ba1\u7406")
@Controller
@RequestMapping(value={"/fs"})
public class FSController {
    @Autowired
    private FSSupport fileSupport;

    @NkNote(value="1.\u521d\u59cb\u5316")
    @ResponseBody
    @RequestMapping(value={"/init"})
    public ResponseEntity init(@RequestBody FSConfig file) {
        return this.fileSupport.init(file);
    }

    @NkNote(value="2.\u4e0a\u4f20")
    @ResponseBody
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public FileUploadStatus upload(@RequestParam(value="file") MultipartFile file) {
        return this.fileSupport.upload(file);
    }

    @ResponseBody
    @NkNote(value="3.\u751f\u6210\u4e0b\u8f7dURL")
    @RequestMapping(value={"/download"}, method={RequestMethod.GET})
    public ResponseEntity download(String url) {
        return this.fileSupport.download(url);
    }

    @ResponseBody
    @NkNote(value="4.\u83b7\u53d6\u4e0b\u8f7d\u6587\u4ef6\u6d41")
    @RequestMapping(value={"/d/{base}/**"}, method={RequestMethod.GET})
    public ResponseEntity downloadFile(@PathVariable String base, HttpServletRequest request) throws OperationNotSupportedException {
        String path = request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE).toString();
        String bestMatchingPattern = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE).toString();
        String filePath = base + File.separatorChar + new AntPathMatcher().extractPathWithinPattern(bestMatchingPattern, path);
        if (this.fileSupport instanceof DefaultFileSupportImpl) {
            return ((DefaultFileSupportImpl)this.fileSupport).downloadFile(filePath);
        }
        throw new OperationNotSupportedException();
    }
}

