/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.platform.controller;

import cn.nkpro.elcube.annotation.NkNote;
import cn.nkpro.elcube.platform.service.DeployService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@NkNote(value="99.[DevOps]\u90e8\u7f72\u5bfc\u5165\u5bfc\u51fa")
@RestController
@RequestMapping(value={"/ops/deploy"})
@PreAuthorize(value="hasAnyAuthority('*:*','DEVOPS:*','DEVOPS:DEPLOY')")
public class DevOpsDeployController {
    @Autowired
    private DeployService deployService;

    @NkNote(value="1.\u52a0\u8f7d\u5bfc\u51fa\u914d\u7f6e")
    @ResponseBody
    @RequestMapping(value={"/load"})
    public JSONArray load() {
        return this.deployService.load();
    }

    @ResponseBody
    @NkNote(value="2.\u5bfc\u51fa")
    @RequestMapping(value={"/export"})
    public ResponseEntity<ByteArrayResource> buildExportKey(@RequestBody JSONObject config) {
        byte[] export = this.deployService.export(config).getBytes(StandardCharsets.UTF_8);
        String date = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
        String filename = "config." + date + ".elcube";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDispositionFormData("attachment", new String(filename.getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        headers.setContentLength((long)export.length);
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength((long)export.length).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)new ByteArrayResource(export));
    }

    @NkNote(value="3.\u5bfc\u5165")
    @ResponseBody
    @RequestMapping(value={"/import"})
    public List<String> defImport(@RequestBody String pointsTxt) {
        return this.deployService.imports(pointsTxt);
    }
}

