/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.platform;

import cn.nkpro.elcube.co.NkComponentException;
import cn.nkpro.elcube.exception.NkAccessDeniedException;
import cn.nkpro.elcube.exception.NkDebugContextNotFoundException;
import cn.nkpro.elcube.exception.NkDefineException;
import cn.nkpro.elcube.exception.abstracts.NkCaution;
import cn.nkpro.elcube.exception.abstracts.NkRuntimeException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private static Map<Class<? extends Throwable>, Integer> codes = new LinkedHashMap<Class<? extends Throwable>, Integer>();

    @ExceptionHandler(value={Exception.class})
    public ModelAndView errorHandler(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        String message = ex.getMessage();
        if (StringUtils.isBlank((CharSequence)message)) {
            message = ex instanceof NullPointerException ? "\u7a7a\u6307\u9488" : "\u672a\u77e5\u9519\u8bef";
        }
        log.error(message, (Throwable)ex);
        response.setStatus(500);
        for (Class<? extends Throwable> type : codes.keySet()) {
            if (!ClassUtils.isAssignable(ex.getClass(), type)) continue;
            response.setStatus(codes.get(type).intValue());
            break;
        }
        MappingJackson2JsonView view = new MappingJackson2JsonView();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("code", response.getStatus());
        attributes.put("msg", message);
        attributes.put("url", request.getRequestURI().substring(request.getContextPath().length()));
        attributes.put("causeStackTrace", ExceptionUtils.getRootCauseStackTrace((Throwable)ex));
        view.setAttributesMap(attributes);
        ModelAndView mav = new ModelAndView("error");
        mav.setView((View)view);
        return mav;
    }

    static {
        codes.put(NkCaution.class, 400);
        codes.put(IllegalArgumentException.class, 400);
        codes.put(AuthenticationException.class, 401);
        codes.put(AccessDeniedException.class, 403);
        codes.put(NkAccessDeniedException.class, 403);
        codes.put(NkDebugContextNotFoundException.class, 701);
        codes.put(NkComponentException.class, 501);
        codes.put(NkDefineException.class, 501);
        codes.put(NkRuntimeException.class, 501);
    }
}

