/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.data.redis.defaults;

import cn.nkpro.elcube.data.redis.EnvRedisTemplate;
import cn.nkpro.elcube.data.redis.RedisSupport;
import cn.nkpro.elcube.exception.abstracts.NkRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.Assert;

public class DefaultRedisSupportImpl<T>
implements RedisSupport<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultRedisSupportImpl.class);
    @Autowired
    private EnvRedisTemplate<T> redisTemplate;
    @Autowired
    private EnvRedisTemplate<String> stringRedisTemplate;

    @Override
    public Set<String> keys(String pattern) {
        return this.redisTemplate.keys(pattern);
    }

    @Override
    public void clear() {
        List<String> keysKeepPrefix = Arrays.asList("stream", "debug", "lock", "keep", "runtime");
        Optional.ofNullable(this.redisTemplate.keys("*")).ifPresent(list -> {
            List collect = list.stream().filter(key -> keysKeepPrefix.stream().noneMatch(pre -> {
                String preUpper;
                String keyUpper = key.toUpperCase();
                return keyUpper.startsWith((preUpper = pre.toUpperCase()) + ":") || keyUpper.startsWith(preUpper + "_");
            })).collect(Collectors.toList());
            if (collect.size() > 0) {
                this.redisTemplate.delete(collect);
            }
        });
    }

    @Override
    public boolean exists(String key) {
        Boolean B = this.redisTemplate.hasKey(key);
        return B == null ? false : B;
    }

    @Override
    public void expire(String key, long timeout) {
        this.redisTemplate.expire(key, timeout, TimeUnit.SECONDS);
    }

    @Override
    public Long getExpire(String key) {
        return this.redisTemplate.getExpire(key, TimeUnit.SECONDS);
    }

    @Override
    public long increment(String key, long l) {
        Long L = this.redisTemplate.opsForValue().increment((Object)key, l);
        Assert.notNull((Object)L, (String)"Redis\u51fa\u73b0\u9519\u8bef");
        return L;
    }

    @Override
    public void set(String key, T value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    @Override
    public T get(String key) {
        return (T)this.redisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public T getIfAbsent(String key, RedisSupport.Function<T> mapper) throws NkRuntimeException {
        return this.getIfAbsent(key, false, mapper);
    }

    @Override
    public T getIfAbsent(String key, boolean cacheNullValue, RedisSupport.Function<T> mapper) throws NkRuntimeException {
        Assert.notNull((Object)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        ValueOperations valueOperations = this.redisTemplate.opsForValue();
        Object value = valueOperations.get((Object)key);
        if (value == null) {
            value = mapper.apply();
            if (cacheNullValue || value != null) {
                valueOperations.set((Object)key, value);
            }
        }
        return (T)value;
    }

    @Override
    public void delete(String ... key) {
        Assert.notNull((Object)key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        this.redisTemplate.delete(Arrays.asList(key));
    }

    @Override
    public void delete(Collection<String> key) {
        Assert.notNull(key, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        this.redisTemplate.delete(key);
    }

    @Override
    public void deletes(String keysLike) {
        Assert.notNull((Object)keysLike, (String)"key\u4e0d\u80fd\u4e3a\u7a7a");
        Set keys = this.redisTemplate.keys(keysLike);
        if (keys != null) {
            this.redisTemplate.delete(keys);
        }
    }

    @Override
    public void set(String hash, String key, T value) {
        this.redisTemplate.opsForHash().put((Object)hash, (Object)key, value);
    }

    @Override
    public T get(String hash, String key) {
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        return (T)hashOperations.get((Object)hash, (Object)key);
    }

    @Override
    public T getIfAbsent(String hash, String keys, RedisSupport.Function<T> mapper) throws NkRuntimeException {
        return this.getIfAbsent(hash, keys, false, mapper);
    }

    @Override
    public T getIfAbsent(String hash, String keys, boolean cacheNullValue, RedisSupport.Function<T> mapper) throws NkRuntimeException {
        Assert.notNull((Object)hash, (String)"hash\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)keys, (String)"keys\u4e0d\u80fd\u4e3a\u7a7a");
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        Object value = hashOperations.get((Object)hash, (Object)keys);
        if (value == null) {
            value = mapper.apply();
            if (cacheNullValue || value != null) {
                hashOperations.put((Object)hash, (Object)keys, value);
            }
        }
        return (T)value;
    }

    @Override
    public Map<String, T> getHash(String hash) {
        Assert.notNull((Object)hash, (String)"hash\u4e0d\u80fd\u4e3a\u7a7a");
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        return hashOperations.entries((Object)hash);
    }

    @Override
    public Map<String, T> getHash(String hash, String ... keys) {
        return this.getHash(hash, Arrays.asList(keys));
    }

    @Override
    public Map<String, T> getHash(String hash, Collection<String> keys) {
        Assert.notNull((Object)hash, (String)"hash\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull(keys, (String)"keys\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(keys, (String)"keys\u4e0d\u80fd\u4e3a\u7a7a");
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        List list = hashOperations.multiGet((Object)hash, keys);
        ArrayList<String> listKey = new ArrayList<String>(keys);
        return keys.stream().collect(Collectors.toMap(key -> key, key -> list.get(listKey.indexOf(key))));
    }

    @Override
    public Map<String, T> getHashIfAbsent(String hash, RedisSupport.Function<Map<String, T>> mapper) {
        Assert.notNull((Object)hash, (String)"hash\u4e0d\u80fd\u4e3a\u7a7a");
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        Map<String, T> value = hashOperations.entries((Object)hash);
        if (MapUtils.isEmpty((Map)value) && MapUtils.isNotEmpty(value = mapper.apply())) {
            hashOperations.putAll((Object)hash, value);
        }
        return value;
    }

    @Override
    public void deleteHash(String hash, Object ... keys) {
        Assert.notNull((Object)hash, (String)"hash\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)keys, (String)"keys\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Object[])keys, (String)"keys\u4e0d\u80fd\u4e3a\u7a7a");
        this.redisTemplate.opsForHash().delete((Object)hash, keys);
    }

    @Override
    public void deleteHash(String hash, Collection<String> keys) {
        this.deleteHash(hash, keys.toArray());
    }

    @Override
    public String lock(String id, int expireSeconds) {
        String value = UUID.randomUUID().toString();
        ValueOperations ops = this.stringRedisTemplate.opsForValue();
        Boolean setIfAbsent = ops.setIfAbsent((Object)("LOCK:" + id), (Object)value);
        if (setIfAbsent != null && setIfAbsent.booleanValue()) {
            this.redisTemplate.expire("LOCK:" + id, expireSeconds, TimeUnit.SECONDS);
            return value;
        }
        return null;
    }

    @Override
    public void unlock(String id, String value) {
        String s = (String)this.stringRedisTemplate.opsForValue().get((Object)("LOCK:" + id));
        if (Objects.equals(s, value)) {
            this.stringRedisTemplate.delete("LOCK:" + id);
        }
    }
}

