/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.data.redis;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.lang.Nullable;

public class EnvRedisTemplate<V>
extends RedisTemplate<String, V>
implements InitializingBean {
    private String env;

    public EnvRedisTemplate(RedisConnectionFactory factory, String env) {
        this.env = env;
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.EXISTING_PROPERTY);
        GenericJackson2JsonRedisSerializer jsonRedisSerializer = new GenericJackson2JsonRedisSerializer();
        this.setKeySerializer((RedisSerializer)new EnvStringRedisSerializer());
        this.setValueSerializer((RedisSerializer)jsonRedisSerializer);
        this.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        this.setHashValueSerializer((RedisSerializer)jsonRedisSerializer);
        this.setConnectionFactory(factory);
        this.afterPropertiesSet();
    }

    private String buildKey(String key) {
        if (StringUtils.isNotBlank((CharSequence)this.env)) {
            return String.format("%s:%s", this.env, key);
        }
        return key;
    }

    class EnvStringRedisSerializer
    extends StringRedisSerializer {
        EnvStringRedisSerializer() {
        }

        public String deserialize(@Nullable byte[] bytes) {
            String key = super.deserialize(bytes);
            if (StringUtils.isNotBlank((CharSequence)EnvRedisTemplate.this.env) && key != null) {
                return key.substring(EnvRedisTemplate.this.env.length() + 1);
            }
            return key;
        }

        public byte[] serialize(@Nullable String string) {
            return super.serialize(EnvRedisTemplate.this.buildKey(string));
        }
    }
}

