/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.data.mybatis.pagination;

import cn.nkpro.elcube.data.mybatis.pagination.PaginationContext;
import cn.nkpro.elcube.data.mybatis.pagination.dialect.Dialect;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class PaginationInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(PaginationInterceptor.class);
    private Dialect dialect = null;
    private static int MAPPED_STATEMENT_INDEX = 0;
    private static int PARAMETER_INDEX = 1;
    private static int ROWBOUNDS_INDEX = 2;

    public Object intercept(Invocation invocation) throws Throwable {
        this.processIntercept(invocation.getArgs());
        return invocation.proceed();
    }

    private void processIntercept(Object[] queryArgs) {
        MappedStatement mappedStatement = (MappedStatement)queryArgs[MAPPED_STATEMENT_INDEX];
        Object parameter = queryArgs[PARAMETER_INDEX];
        RowBounds rowBounds = (RowBounds)queryArgs[ROWBOUNDS_INDEX];
        BoundSql boundSql = mappedStatement.getBoundSql(parameter);
        String originalSql = boundSql.getSql().trim();
        Object parameterObject = boundSql.getParameterObject();
        if (log.isTraceEnabled()) {
            log.trace("Parameter = " + parameter);
            log.trace("RowBounds = " + rowBounds);
            log.trace("Default RowBounds = " + (rowBounds == RowBounds.DEFAULT));
        }
        if (rowBounds == null || rowBounds == RowBounds.DEFAULT) {
            return;
        }
        PaginationContext context = PaginationContext.getContext();
        if (context != null) {
            PaginationContext.removeContext();
            int totalRows = 0;
            String countSql = originalSql.replaceAll("(?<=select)[\\s\\S]*?(?=from)", " count(*) ").replaceAll("order by.*", "");
            if (log.isTraceEnabled()) {
                log.trace("\u751f\u6210\u67e5\u8be2\u6570\u91cfSQL : " + originalSql);
                log.trace("\u751f\u6210\u67e5\u8be2\u6570\u91cfSQL : " + countSql);
            }
            Connection connection = null;
            try {
                connection = mappedStatement.getConfiguration().getEnvironment().getDataSource().getConnection();
                PreparedStatement countStmt = connection.prepareStatement(countSql);
                BoundSql countBS = this.copyFromBoundSql(mappedStatement, boundSql, countSql);
                this.setParameters(countStmt, mappedStatement, countBS, parameterObject);
                ResultSet rs = countStmt.executeQuery();
                if (rs.next()) {
                    totalRows = rs.getInt(1);
                }
                rs.close();
                countStmt.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException("\u6570\u636e\u5e93\u5173\u95ed\u51fa\u9519", e);
                }
            }
            context.setTotal(totalRows);
        }
        String pagesql = this.dialect.getLimitString(originalSql, rowBounds.getOffset(), rowBounds.getLimit());
        queryArgs[PaginationInterceptor.ROWBOUNDS_INDEX] = new RowBounds(0, Integer.MAX_VALUE);
        BoundSql newBoundSql = this.copyFromBoundSql(mappedStatement, boundSql, pagesql);
        MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, new BoundSqlSqlSource(newBoundSql));
        queryArgs[PaginationInterceptor.MAPPED_STATEMENT_INDEX] = newMs;
        if (log.isTraceEnabled()) {
            log.trace("\u751f\u6210\u5206\u9875SQL : " + newBoundSql.getSql().replaceAll("\n", " ").replaceAll("\\s{2,}", " "));
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
        if (log.isInfoEnabled()) {
            log.info("dialect=" + dialect.getClass());
        }
    }

    private BoundSql copyFromBoundSql(MappedStatement ms, BoundSql boundSql, String sql) {
        BoundSql newBoundSql = new BoundSql(ms.getConfiguration(), sql, boundSql.getParameterMappings(), boundSql.getParameterObject());
        for (ParameterMapping mapping : boundSql.getParameterMappings()) {
            String prop = mapping.getProperty();
            if (!boundSql.hasAdditionalParameter(prop)) continue;
            newBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
        }
        return newBoundSql;
    }

    private void setParameters(PreparedStatement ps, MappedStatement mappedStatement, BoundSql boundSql, Object parameterObject) throws SQLException {
        ErrorContext.instance().activity("setting parameters").object(mappedStatement.getParameterMap().getId());
        List parameterMappings = boundSql.getParameterMappings();
        if (parameterMappings != null) {
            Configuration configuration = mappedStatement.getConfiguration();
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            MetaObject metaObject = parameterObject == null ? null : configuration.newMetaObject(parameterObject);
            for (int i = 0; i < parameterMappings.size(); ++i) {
                Object value;
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                PropertyTokenizer prop = new PropertyTokenizer(propertyName);
                if (parameterObject == null) {
                    value = null;
                } else if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                    value = parameterObject;
                } else if (boundSql.hasAdditionalParameter(propertyName)) {
                    value = boundSql.getAdditionalParameter(propertyName);
                } else if (propertyName.startsWith("__frch_") && boundSql.hasAdditionalParameter(prop.getName())) {
                    value = boundSql.getAdditionalParameter(prop.getName());
                    if (value != null) {
                        value = configuration.newMetaObject(value).getValue(propertyName.substring(prop.getName().length()));
                    }
                } else {
                    value = metaObject == null ? null : metaObject.getValue(propertyName);
                }
                TypeHandler typeHandler = parameterMapping.getTypeHandler();
                if (typeHandler == null) {
                    throw new ExecutorException("There was no TypeHandler found for parameter " + propertyName + " of statement " + mappedStatement.getId());
                }
                typeHandler.setParameter(ps, i + 1, value, parameterMapping.getJdbcType());
            }
        }
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public static class BoundSqlSqlSource
    implements SqlSource {
        BoundSql boundSql;

        BoundSqlSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

