/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.data.jdbc;

import cn.nkpro.elcube.co.easy.EasySingle;
import cn.nkpro.elcube.data.jdbc.Utils;
import cn.nkpro.elcube.exception.NkSystemException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.util.Assert;

class NkObjectResultSetExtractor<T>
implements ResultSetExtractor<List<T>> {
    private Integer expect;
    private Class<T> expectType;

    NkObjectResultSetExtractor(@NotNull Class<T> expectType) {
        this.expectType = expectType;
    }

    NkObjectResultSetExtractor(@NotNull Class<T> expectType, Integer expect) {
        this.expectType = expectType;
        this.expect = expect;
    }

    public List<T> extractData(ResultSet resultSet) throws SQLException, DataAccessException {
        Assert.isTrue((this.expect == null || resultSet.getRow() <= this.expect ? 1 : 0) != 0, (String)("\u67e5\u8be2\u6570\u636e\u5e93\u9519\u8bef\uff0c\u671f\u671b\u7ed3\u679c\u6761\u76ee\u4e3a" + this.expect + "\uff0c\u5b9e\u9645\u6570\u636e\u6570\u91cf\u4e3a" + resultSet.getRow()));
        ArrayList<T> list = new ArrayList<T>();
        while (resultSet.next()) {
            T result;
            try {
                result = this.expectType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new NkSystemException((Throwable)e);
            }
            EasySingle single = EasySingle.from(result);
            ResultSetMetaData meta = resultSet.getMetaData();
            for (int i = 0; i < meta.getColumnCount(); ++i) {
                String columnName = meta.getColumnName(i + 1);
                String fieldName = Utils.translate(columnName, false);
                single.set(fieldName, resultSet.getObject(columnName));
            }
            list.add(result);
        }
        return list;
    }
}

