/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.data.jdbc;

import cn.nkpro.elcube.co.easy.EasyCollection;
import cn.nkpro.elcube.co.easy.EasySingle;
import cn.nkpro.elcube.data.jdbc.NkObjectResultSetExtractor;
import cn.nkpro.elcube.data.jdbc.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class NkJdbcTemplate {
    @Autowired
    protected JdbcTemplate jdbcTemplate;

    public void upsert(@NotNull String tableName, @NotNull List<String> upsertFields, @NotNull List<String> keyFields, @NotNull Object data) {
        Assert.notEmpty(upsertFields, (String)"\u66f4\u65b0\u5b57\u6bb5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(keyFields, (String)"\u4e3b\u952e\u5b57\u6bb5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        EasySingle single = EasySingle.from(data);
        ArrayList args = new ArrayList();
        ArrayList sqlWhereBuilder = new ArrayList();
        keyFields.forEach(key -> {
            sqlWhereBuilder.add(Utils.reverse(key) + " = ?");
            args.add(single.get((String)key));
        });
        Integer integer = (Integer)this.jdbcTemplate.queryForObject(String.format("SELECT COUNT(1) AS COUNT FROM %s WHERE %s", tableName, String.join((CharSequence)" AND ", sqlWhereBuilder)), Integer.class, args.toArray());
        args.clear();
        if (integer == null || integer == 0) {
            ArrayList sqlInsertFieldBuilder = new ArrayList();
            upsertFields.forEach(field -> {
                sqlInsertFieldBuilder.add(Utils.reverse(field));
                args.add(single.get((String)field));
            });
            keyFields.forEach(key -> {
                if (!upsertFields.contains(key)) {
                    sqlInsertFieldBuilder.add(Utils.reverse(key));
                    args.add(single.get((String)key));
                }
            });
            String insertSql = String.format("INSERT INTO %s(%s) VALUES(%s)", tableName, String.join((CharSequence)", ", sqlInsertFieldBuilder), sqlInsertFieldBuilder.stream().map(e -> "?").collect(Collectors.joining(", ")));
            this.jdbcTemplate.update(insertSql, args.toArray());
        } else {
            ArrayList sqlSetBuilder = new ArrayList();
            upsertFields.forEach(field -> {
                sqlSetBuilder.add(Utils.reverse(field) + " = ?");
                args.add(single.get((String)field));
            });
            sqlWhereBuilder.clear();
            keyFields.forEach(key -> {
                sqlWhereBuilder.add(Utils.reverse(key) + " = ?");
                args.add(single.get((String)key));
            });
            String updateSql = String.format("UPDATE %s SET %s WHERE %s", tableName, String.join((CharSequence)", ", sqlSetBuilder), String.join((CharSequence)" AND ", sqlWhereBuilder));
            this.jdbcTemplate.update(updateSql, args.toArray());
        }
    }

    public void batchUpsert(@NotNull String tableName, @NotNull List<String> upsertFields, @NotNull List<String> keyFields, Map<String, Object> existsQueryParams, @NotNull List<Object> data) {
        Assert.notEmpty(upsertFields, (String)"\u66f4\u65b0\u5b57\u6bb5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(keyFields, (String)"\u4e3b\u952e\u5b57\u6bb5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList args = new ArrayList();
        String where = "";
        if (MapUtils.isNotEmpty(existsQueryParams)) {
            ArrayList sqlWhereBuilder = new ArrayList();
            existsQueryParams.forEach((k, v) -> {
                sqlWhereBuilder.add(k);
                if (v instanceof Collection) {
                    args.addAll((Collection)v);
                } else {
                    args.add(v);
                }
            });
            where = "WHERE " + String.join((CharSequence)" AND ", sqlWhereBuilder);
        }
        String existsSql = String.format("SELECT %s FROM %s %s", keyFields.stream().map(Utils::reverse).collect(Collectors.joining(",")), tableName, where);
        List exists = this.jdbcTemplate.queryForList(existsSql, args.toArray()).stream().map(i -> i.keySet().stream().sorted().map(i::get).map(v -> v == null ? "" : v).map(Object::toString).collect(Collectors.joining(":"))).collect(Collectors.toList());
        List keys = keyFields.stream().sorted().collect(Collectors.toList());
        ArrayList updateArgs = new ArrayList();
        ArrayList insertArgs = new ArrayList();
        SetUtils.SetView insertFields = SetUtils.union(new HashSet<String>(upsertFields), new HashSet<String>(keyFields));
        EasyCollection.from(data).forEach(arg_0 -> NkJdbcTemplate.lambda$batchUpsert$13(keys, exists, upsertFields, keyFields, updateArgs, (Set)insertFields, insertArgs, arg_0));
        if (!updateArgs.isEmpty()) {
            String updateSql = String.format("UPDATE %s SET %s WHERE %s", tableName, upsertFields.stream().map(Utils::reverse).map(key -> String.format("%s = ?", key)).collect(Collectors.joining(",")), keyFields.stream().map(Utils::reverse).map(key -> String.format("%s = ?", key)).collect(Collectors.joining(" AND ")));
            this.jdbcTemplate.batchUpdate(updateSql, updateArgs);
        }
        if (!insertArgs.isEmpty()) {
            String insertSql = String.format("INSERT INTO %s(%s) VALUES(%s)", tableName, insertFields.stream().map(Utils::reverse).collect(Collectors.joining(",")), insertFields.stream().map(Utils::reverse).map(key -> "?").collect(Collectors.joining(",")));
            this.jdbcTemplate.batchUpdate(insertSql, insertArgs);
        }
    }

    public HashMap querySingle(String tableName, List<String> fetchFields, Map<String, Object> params) {
        return ((List)((Object)this.query(tableName, fetchFields, params, null, new NkObjectResultSetExtractor<HashMap>(HashMap.class, 1)))).stream().findFirst().orElse(null);
    }

    public <T> T querySingle(String tableName, List<String> fetchFields, Map<String, Object> params, Class<T> type) {
        return ((List)this.query(tableName, fetchFields, params, null, new NkObjectResultSetExtractor<T>(type, 1))).stream().findFirst().orElse(null);
    }

    public List<HashMap> queryList(String tableName, List<String> fetchFields, Map<String, Object> params, String orderBy) {
        return (List)((Object)this.query(tableName, fetchFields, params, orderBy, new NkObjectResultSetExtractor<HashMap>(HashMap.class)));
    }

    public <T> List<T> queryList(String tableName, List<String> fetchFields, Map<String, Object> params, String orderBy, Class<T> type) {
        return (List)this.query(tableName, fetchFields, params, orderBy, new NkObjectResultSetExtractor<T>(type));
    }

    private <T> T query(String tableName, List<String> fetchFields, Map<String, Object> params, String orderBy, ResultSetExtractor<T> resultSetExtractor) {
        ArrayList<String> sqlBuilder = new ArrayList<String>();
        ArrayList args = new ArrayList();
        sqlBuilder.add("SELECT");
        if (CollectionUtils.isNotEmpty(fetchFields)) {
            sqlBuilder.add(fetchFields.stream().map(Utils::reverse).collect(Collectors.joining(",")));
        } else {
            sqlBuilder.add("*");
        }
        sqlBuilder.add("FROM");
        sqlBuilder.add(tableName);
        if (MapUtils.isNotEmpty(params)) {
            sqlBuilder.add("WHERE");
            ArrayList sqlWhereBuilder = new ArrayList();
            params.forEach((k, v) -> {
                sqlWhereBuilder.add(k);
                if (v instanceof Collection) {
                    args.addAll((Collection)v);
                } else {
                    args.add(v);
                }
            });
            sqlBuilder.add(String.join((CharSequence)" AND ", sqlWhereBuilder));
        }
        if (StringUtils.isNotBlank((CharSequence)orderBy)) {
            sqlBuilder.add("ORDER BY");
            sqlBuilder.add(orderBy);
        }
        return (T)this.jdbcTemplate.query(String.join((CharSequence)" ", sqlBuilder), args.toArray(), resultSetExtractor);
    }

    private static /* synthetic */ void lambda$batchUpsert$13(List keys, List exists, List upsertFields, List keyFields, List updateArgs, Set insertFields, List insertArgs, EasySingle single) {
        String joinedKey = keys.stream().map(single::get).map(v -> v == null ? "" : v).map(Object::toString).collect(Collectors.joining(":"));
        ArrayList arg = new ArrayList();
        if (exists.contains(joinedKey)) {
            upsertFields.forEach(field -> arg.add(single.get((String)field)));
            keyFields.forEach(key -> arg.add(single.get((String)key)));
            updateArgs.add(arg.toArray());
        } else {
            insertFields.forEach(field -> arg.add(single.get((String)field)));
            insertArgs.add(arg.toArray());
        }
    }
}

