/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.data.elasticearch;

import cn.nkpro.elcube.basic.TransactionSync;
import cn.nkpro.elcube.data.elasticearch.AbstractESModel;
import cn.nkpro.elcube.data.elasticearch.ESContentBuilder;
import cn.nkpro.elcube.data.elasticearch.ESSqlRequest;
import cn.nkpro.elcube.data.elasticearch.ESSqlResponse;
import cn.nkpro.elcube.data.elasticearch.annotation.ESDocument;
import cn.nkpro.elcube.exception.NkDefineException;
import cn.nkpro.elcube.exception.NkInputFailedCaution;
import cn.nkpro.elcube.exception.NkSystemException;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class SearchEngine
extends ESContentBuilder {
    private static final Logger log = LoggerFactory.getLogger(SearchEngine.class);
    private static Pattern p_repl = Pattern.compile("\\s[Ff][Rr][Oo][Mm]\\s*[\"]?([^\\s\"]*)[\"]?");
    private static Pattern p_find = Pattern.compile("^[\\w\\W]*\\s[Ff][Rr][Oo][Mm]\\s*[\"]?([^\\s\"]*)[\"]?[\\w\\W]*$");
    @Autowired
    private RestHighLevelClient client;

    @Scheduled(cron="0 * * * * ?")
    public void heartbeat() {
        try {
            this.client.ping(RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            log.error("indices heartbeat error", (Throwable)e);
        }
    }

    public FieldCapabilitiesResponse getFieldCaps(String index) {
        try {
            return this.client.fieldCaps(new FieldCapabilitiesRequest().indices(new String[]{this.getIndexPrefix() + index}).fields(new String[]{"*"}), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new NkSystemException("\u641c\u7d22\u5f15\u64ce\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public String parseSqlIndex(String query) {
        Matcher matcher = p_find.matcher(query);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new NkDefineException("\u6ca1\u6709\u5339\u914d\u5230\u6b63\u786e\u7684\u7d22\u5f15\u540d\u79f0");
    }

    public ESSqlResponse sql(ESSqlRequest sqlRequest) {
        sqlRequest.setQuery(p_repl.matcher(sqlRequest.getQuery()).replaceFirst(" FROM \"" + this.getIndexPrefix() + "$1\""));
        Request request = new Request("GET", "/_sql");
        request.setJsonEntity(sqlRequest.toString());
        try {
            if (log.isDebugEnabled()) {
                log.debug("ES._sql : " + sqlRequest.toString());
            }
            Response response = this.client.getLowLevelClient().performRequest(request);
            return (ESSqlResponse)JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()), ESSqlResponse.class);
        }
        catch (IOException e) {
            if (e instanceof ResponseException) {
                try {
                    throw new NkInputFailedCaution("\u68c0\u7d22\u9519\u8bef\uff1a" + EntityUtils.toString((HttpEntity)((ResponseException)e).getResponse().getEntity()));
                }
                catch (IOException ee) {
                    throw new NkSystemException("\u641c\u7d22\u5f15\u64ce\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
            throw new NkSystemException("\u641c\u7d22\u5f15\u64ce\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public SearchResponse search(String indexName, SearchSourceBuilder builder) {
        try {
            SearchSourceBuilder sourceBuilder = builder.trackTotalHits(true).timeout(new TimeValue(10L, TimeUnit.SECONDS));
            if (log.isDebugEnabled()) {
                log.debug("ES._search : " + sourceBuilder);
            }
            SearchRequest searchRequest = new SearchRequest().indices(new String[]{this.documentIndex(indexName)}).source(sourceBuilder);
            return this.client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new NkSystemException("\u641c\u7d22\u5f15\u64ce\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public <T extends AbstractESModel> SearchResponse search(Class<T> docType, SearchSourceBuilder builder) {
        return this.search(this.parseDocument(docType), builder);
    }

    public <T extends AbstractESModel> boolean exists(Class<T> docType, SearchSourceBuilder builder) throws IOException {
        try {
            ESDocument document = docType.getAnnotation(ESDocument.class);
            if (document == null) {
                throw new RuntimeException(String.format("\u7c7b\u578b %s \u7684 ESDocument \u6ce8\u89e3\u4e0d\u5b58\u5728", docType.getName()));
            }
            SearchRequest searchRequest = new SearchRequest().indices(new String[]{this.documentIndex(document.value())}).source(builder.timeout(new TimeValue(10L, TimeUnit.SECONDS)).fetchSource(false));
            return this.client.search((SearchRequest)searchRequest, (RequestOptions)RequestOptions.DEFAULT).getHits().getTotalHits().value > 0L;
        }
        catch (IOException e) {
            throw new NkSystemException("\u641c\u7d22\u5f15\u64ce\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public void deleteBeforeCommit(Class<? extends AbstractESModel> esType, QueryBuilder query) {
        TransactionSync.runBeforeCommit("\u5220\u9664\u7d22\u5f15", () -> {
            try {
                this.client.deleteByQuery(new DeleteByQueryRequest(new String[]{this.documentIndex(this.parseDocument((Class)esType))}).setQuery(query), RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                throw new NkSystemException("\u641c\u7d22\u5f15\u64ce\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
            }
        });
    }

    public void deleteBeforeCommit(Class<? extends AbstractESModel> esType, String ... id) {
        this.deleteBeforeCommit(esType, Arrays.asList(id));
    }

    public void deleteBeforeCommit(Class<? extends AbstractESModel> esType, Collection<String> keys) {
        TransactionSync.runBeforeCommit("\u5220\u9664\u7d22\u5f15" + keys.size(), () -> {
            try {
                for (String id : keys) {
                    this.client.delete(new DeleteRequest(this.documentIndex(this.parseDocument((Class)esType)), id), RequestOptions.DEFAULT);
                }
            }
            catch (IOException e) {
                throw new NkSystemException("\u641c\u7d22\u5f15\u64ce\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
            }
        });
    }

    public void updateBeforeCommit(AbstractESModel ... docs) {
        this.updateBeforeCommit(Arrays.asList(docs));
    }

    public void updateBeforeCommit(Collection<AbstractESModel> docs) {
        TransactionSync.runBeforeCommit("\u66f4\u65b0\u7d22\u5f15", () -> {
            for (AbstractESModel doc : docs) {
                doc.validateDynamic();
            }
            try {
                for (AbstractESModel doc : docs) {
                    this.client.update(new UpdateRequest(this.documentIndex(this.parseDocument(doc.getClass())), this.parseDocId(doc)).docAsUpsert(true).upsert(new Object[0]).doc(doc.toSource()), RequestOptions.DEFAULT);
                }
            }
            catch (IOException e) {
                throw new NkSystemException("\u641c\u7d22\u5f15\u64ce\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
            }
        });
    }

    public void indexBeforeCommit(AbstractESModel ... docs) {
        this.indexBeforeCommit(Arrays.asList(docs));
    }

    public void indexBeforeCommit(String indexName, AbstractESModel ... docs) {
        this.indexBeforeCommit(indexName, Arrays.asList(docs));
    }

    public void indexBeforeCommit(Collection<AbstractESModel> docs) {
        this.indexBeforeCommit(null, docs);
    }

    public void indexBeforeCommit(String indexName, Collection<AbstractESModel> docs) {
        TransactionSync.runBeforeCommit("\u521b\u5efa\u7d22\u5f15", () -> {
            if (log.isInfoEnabled()) {
                log.info("\u91cd\u5efa\u7d22\u5f15\u5f00\u59cb \u6570\u91cf = {}", (Object)docs.size());
            }
            for (AbstractESModel doc : docs) {
                doc.validateDynamic();
            }
            try {
                for (AbstractESModel doc : docs) {
                    String name = (String)StringUtils.defaultIfBlank((CharSequence)indexName, (CharSequence)this.parseDocument(doc.getClass()));
                    this.client.index(new IndexRequest(this.documentIndex(name)).id(this.parseDocId(doc)).source(doc.toSource()), RequestOptions.DEFAULT);
                    if (!log.isInfoEnabled()) continue;
                    log.info("\u91cd\u5efa\u7d22\u5f15 DOC = {}", (Object)doc);
                }
                if (log.isInfoEnabled()) {
                    log.info("\u91cd\u5efa\u7d22\u5f15\u5b8c\u6210 \u6570\u91cf = {}", (Object)docs.size());
                }
            }
            catch (IOException e) {
                throw new NkSystemException("\u641c\u7d22\u5f15\u64ce\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
            }
        });
    }

    private boolean existsIndices(String indexName) throws IOException {
        try {
            return this.client.indices().exists(new GetIndexRequest(new String[]{this.documentIndex(indexName)}), RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new NkSystemException("\u641c\u7d22\u5f15\u64ce\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public void deleteIndices(String indexName) throws IOException {
        if (this.existsIndices(indexName)) {
            try {
                this.client.indices().delete(new DeleteIndexRequest(this.documentIndex(indexName)), RequestOptions.DEFAULT);
            }
            catch (IOException e) {
                throw new NkSystemException("\u641c\u7d22\u5f15\u64ce\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void deleteIndices(Class<? extends AbstractESModel> docType) throws IOException {
        this.deleteIndices(this.parseDocument((Class)docType));
    }

    public void createIndices(Class<? extends AbstractESModel> docType, String indexName) throws IOException {
        if (this.existsIndices(indexName)) {
            return;
        }
        try {
            CreateIndexRequest request = new CreateIndexRequest(this.documentIndex(indexName));
            request.settings(this.buildNgramTokenizer());
            request.mapping(this.buildMapping(docType));
            this.client.indices().create(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new NkSystemException("\u641c\u7d22\u5f15\u64ce\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public void createIndices(Class<? extends AbstractESModel> docType) throws IOException {
        this.createIndices(docType, this.parseDocument((Class)docType));
    }
}

