/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.data.elasticearch;

import cn.nkpro.elcube.basic.NkProperties;
import cn.nkpro.elcube.data.elasticearch.AbstractESModel;
import cn.nkpro.elcube.data.elasticearch.ESAnalyzerType;
import cn.nkpro.elcube.data.elasticearch.annotation.ESDocument;
import cn.nkpro.elcube.data.elasticearch.annotation.ESDynamicTemplate;
import cn.nkpro.elcube.data.elasticearch.annotation.ESDynamicTemplates;
import cn.nkpro.elcube.data.elasticearch.annotation.ESField;
import cn.nkpro.elcube.data.elasticearch.annotation.ESId;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

class ESContentBuilder {
    @Autowired
    private NkProperties properties;

    ESContentBuilder() {
    }

    public String parseDocument(Class<? extends AbstractESModel> esType) {
        ESDocument document = esType.getAnnotation(ESDocument.class);
        Assert.notNull((Object)document, (String)String.format("\u7c7b\u578b %s \u7684 ESDocument \u6ce8\u89e3\u4e0d\u5b58\u5728", esType.getName()));
        return document.value();
    }

    String parseDocId(AbstractESModel doc) {
        Class<?> esType = doc.getClass();
        return Arrays.stream(esType.getDeclaredFields()).filter(field -> field.getAnnotation(ESId.class) != null).sorted(Comparator.comparing(Field::getName)).map(field -> {
            try {
                field.setAccessible(true);
                Object value = field.get(doc);
                return value == null ? "" : value.toString();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return "";
            }
        }).collect(Collectors.joining("$"));
    }

    XContentBuilder buildNgramTokenizer() throws IOException {
        XContentBuilder settings = XContentFactory.jsonBuilder();
        settings.startObject();
        settings.startObject("analysis");
        settings.startObject("analyzer");
        settings.startObject("ngram_analyzer");
        settings.field("tokenizer", "ngram_tokenizer");
        settings.endObject();
        settings.endObject();
        settings.startObject("tokenizer");
        settings.startObject("ngram_tokenizer");
        settings.field("type", "ngram");
        settings.field("min_gram", 4);
        settings.field("max_gram", 4);
        settings.array("token_chars", new String[]{"letter", "digit"});
        settings.endObject();
        settings.endObject();
        settings.endObject();
        settings.endObject();
        return settings;
    }

    XContentBuilder buildMapping(Class<? extends AbstractESModel> esType) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        ESDynamicTemplate[] array = null;
        ESDynamicTemplates dynamicTemplates = esType.getAnnotation(ESDynamicTemplates.class);
        ESDynamicTemplate dynamicTemplate = esType.getAnnotation(ESDynamicTemplate.class);
        if (dynamicTemplates != null) {
            array = dynamicTemplates.value();
        } else if (dynamicTemplate != null) {
            array = new ESDynamicTemplate[]{dynamicTemplate};
        }
        if (array != null) {
            builder.startArray("dynamic_templates");
            for (ESDynamicTemplate template : array) {
                ESField[] eSFieldArray;
                int n;
                int n2;
                builder.startObject();
                builder.startObject(template.value());
                if (StringUtils.isNotBlank((CharSequence)template.matchMappingType())) {
                    builder.field("match_mapping_type", template.matchMappingType());
                }
                if (StringUtils.isNotBlank((CharSequence)template.match())) {
                    builder.field("match", template.match());
                }
                if (StringUtils.isNotBlank((CharSequence)template.unmatch())) {
                    builder.field("unmatch", template.unmatch());
                }
                builder.startObject("mapping");
                builder.field("type", template.mappingType().getValue());
                if (template.analyzer() != ESAnalyzerType.none) {
                    builder.field("analyzer", (Object)template.analyzer());
                }
                if (template.searchAnalyzer() != ESAnalyzerType.none) {
                    builder.field("search_analyzer", (Object)template.searchAnalyzer());
                }
                if (template.copyToKeyword()) {
                    builder.field("copy_to", "$keyword");
                }
                if (template.original()) {
                    builder.startObject("fields");
                    builder.startObject("original");
                    builder.field("type", "keyword");
                    builder.endObject();
                    builder.endObject();
                }
                if (StringUtils.isNotBlank((CharSequence)template.format())) {
                    builder.field("format", template.format());
                }
                if ((n2 = 0) < (n = (eSFieldArray = template.fields()).length)) {
                    ESField field = eSFieldArray[n2];
                    throw new RuntimeException("\u6682\u4e0d\u652f\u6301");
                }
                builder.endObject();
                builder.endObject();
                builder.endObject();
            }
            builder.endArray();
        }
        builder.startObject("properties");
        Class<? extends AbstractESModel> type = esType;
        do {
            Field[] fields;
            for (Field field : fields = type.getDeclaredFields()) {
                ESField esField = field.getAnnotation(ESField.class);
                if (esField == null) continue;
                builder.startObject(field.getName());
                builder.field("type", esField.type().getValue());
                if (esField.analyzer() != ESAnalyzerType.none) {
                    builder.field("analyzer", (Object)esField.analyzer());
                }
                if (esField.searchAnalyzer() != ESAnalyzerType.none) {
                    builder.field("search_analyzer", (Object)esField.searchAnalyzer());
                }
                if (esField.original()) {
                    builder.startObject("fields");
                    builder.startObject("original");
                    builder.field("type", "keyword");
                    builder.endObject();
                    builder.endObject();
                }
                if (esField.copyToKeyword()) {
                    builder.field("copy_to", "$keyword");
                }
                if (StringUtils.isNotBlank((CharSequence)esField.format())) {
                    builder.field("format", esField.format());
                }
                builder.endObject();
            }
        } while ((type = type.getSuperclass()) != Object.class);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    String documentIndex(String indexName) {
        String prefix = this.properties.getEnvKey();
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            return String.format("%s-%s", prefix, indexName);
        }
        return indexName;
    }

    String getIndexPrefix() {
        String prefix = this.properties.getEnvKey();
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            return String.format("%s-", prefix);
        }
        return "";
    }
}

