/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.data.elasticearch;

import cn.nkpro.elcube.data.elasticearch.ESAnalyzerType;
import cn.nkpro.elcube.data.elasticearch.ESFieldType;
import cn.nkpro.elcube.data.elasticearch.annotation.ESDynamicTemplate;
import cn.nkpro.elcube.data.elasticearch.annotation.ESDynamicTemplates;
import cn.nkpro.elcube.data.elasticearch.annotation.ESField;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ESDynamicTemplates(value={@ESDynamicTemplate(value="keyword", match="*_keyword", mappingType=ESFieldType.Keyword), @ESDynamicTemplate(value="text", match="*_text", mappingType=ESFieldType.Text, analyzer=ESAnalyzerType.ik_max_word, original=true), @ESDynamicTemplate(value="text$", match="*_text$", mappingType=ESFieldType.Text, analyzer=ESAnalyzerType.ik_max_word, original=true, copyToKeyword=true), @ESDynamicTemplate(value="completion", match="*_completion", mappingType=ESFieldType.Completion, analyzer=ESAnalyzerType.ik_max_word, original=true), @ESDynamicTemplate(value="name", match="*_name", mappingType=ESFieldType.Text, analyzer=ESAnalyzerType.standard, original=true), @ESDynamicTemplate(value="name$", match="*_name$", mappingType=ESFieldType.Text, analyzer=ESAnalyzerType.standard, original=true, copyToKeyword=true), @ESDynamicTemplate(value="serial", match="*_serial", mappingType=ESFieldType.Text, analyzer=ESAnalyzerType.ngram_analyzer, original=true), @ESDynamicTemplate(value="serial$", match="*_serial$", mappingType=ESFieldType.Text, analyzer=ESAnalyzerType.ngram_analyzer, original=true, copyToKeyword=true), @ESDynamicTemplate(value="mail", match="*_mail", mappingType=ESFieldType.Text, analyzer=ESAnalyzerType.ngram_analyzer, original=true), @ESDynamicTemplate(value="mail$", match="*_mail$", mappingType=ESFieldType.Text, analyzer=ESAnalyzerType.ngram_analyzer, original=true, copyToKeyword=true), @ESDynamicTemplate(value="url", match="*_url", mappingType=ESFieldType.Text, analyzer=ESAnalyzerType.ngram_analyzer, original=true), @ESDynamicTemplate(value="url$", match="*_url$", mappingType=ESFieldType.Text, analyzer=ESAnalyzerType.ngram_analyzer, original=true, copyToKeyword=true), @ESDynamicTemplate(value="phone", match="*_phone", mappingType=ESFieldType.Text, analyzer=ESAnalyzerType.ngram_analyzer, original=true), @ESDynamicTemplate(value="phone$", match="*_phone$", mappingType=ESFieldType.Text, analyzer=ESAnalyzerType.ngram_analyzer, original=true, copyToKeyword=true), @ESDynamicTemplate(value="bool", match="*_bool*", mappingType=ESFieldType.Boolean), @ESDynamicTemplate(value="int", match="*_int*", mappingType=ESFieldType.Integer), @ESDynamicTemplate(value="long", match="*_long", mappingType=ESFieldType.Long), @ESDynamicTemplate(value="float", match="*_float", mappingType=ESFieldType.Float), @ESDynamicTemplate(value="double", match="*_double", mappingType=ESFieldType.Double), @ESDynamicTemplate(value="date", match="*_date", mappingType=ESFieldType.Date, format="epoch_second||yyyy-MM-dd HH:mm:ss||yyyy-MM-dd"), @ESDynamicTemplate(value="obj", match="*_obj*", mappingType=ESFieldType.Object)})
public abstract class AbstractESModel {
    @ESField(type=ESFieldType.Text, analyzer=ESAnalyzerType.ik_max_word, searchAnalyzer=ESAnalyzerType.ik_smart)
    private List<String> $keyword = new ArrayList<String>();
    private Map<String, Object> dynamics = new HashMap<String, Object>();

    public void addDynamicField(String key, Object value) {
        if (value instanceof Date) {
            this.dynamics.put(key, ((Date)value).getTime() / 1000L);
        } else {
            this.dynamics.put(key, value);
        }
    }

    void validateDynamic() {
        ESDynamicTemplate[] dynamicTemplates = this.dynamicTemplates();
        this.dynamics.keySet().forEach(key -> Assert.isTrue((boolean)Arrays.stream(dynamicTemplates).anyMatch(template -> key.contains(template.match().replaceAll("[*]", ""))), (String)String.format("\u627e\u4e0d\u5230\u53ef\u4ee5\u5339\u914d\u5b57\u6bb5%s\u7684\u52a8\u6001\u6a21\u7248", key)));
    }

    Map<String, Object> toSource() {
        return (JSONObject)JSON.toJSON((Object)this);
    }

    private ESDynamicTemplate[] dynamicTemplates() {
        ESDynamicTemplates dynamicTemplates = this.getClass().getAnnotation(ESDynamicTemplates.class);
        ESDynamicTemplate dynamicTemplate = this.getClass().getAnnotation(ESDynamicTemplate.class);
        ESDynamicTemplate[] array = dynamicTemplates != null ? dynamicTemplates.value() : (dynamicTemplate != null ? new ESDynamicTemplate[]{dynamicTemplate} : new ESDynamicTemplate[]{});
        return array;
    }

    public Map<String, Object> getDynamics() {
        return this.dynamics;
    }
}

