/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.data.clickhouse;

import cn.nkpro.elcube.data.clickhouse.ClickHouseHikariConfig;
import cn.nkpro.elcube.data.clickhouse.ClickHouseProperties;
import cn.nkpro.elcube.data.clickhouse.ClickHouseTemplate;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ClickHouseProperties.class, ClickHouseHikariConfig.class})
public class ClickHouseConfiguration {
    @ConditionalOnProperty(value={"nk.clickhouse.url"})
    @ConfigurationProperties(prefix="nk.clickhouse.url")
    @Bean(value={"clickHouseDataSource"})
    public DataSource clickHouseDataSource(ClickHouseProperties properties) {
        HikariConfig hikari = properties.getHikari();
        if (hikari == null) {
            hikari = new HikariConfig();
        }
        if (StringUtils.isNotBlank((CharSequence)properties.getUrl())) {
            hikari.setJdbcUrl(properties.getUrl());
        }
        if (StringUtils.isNotBlank((CharSequence)properties.getDriverClassName())) {
            hikari.setDriverClassName(properties.getDriverClassName());
        }
        if (StringUtils.isNotBlank((CharSequence)properties.getUsername())) {
            hikari.setUsername(properties.getUsername());
        }
        if (StringUtils.isNotBlank((CharSequence)properties.getPassword())) {
            hikari.setPassword(properties.getPassword());
        }
        return new HikariDataSource(hikari);
    }

    @ConditionalOnBean(name={"clickHouseDataSource"})
    @Bean
    public ClickHouseTemplate clickHouseJdbcTemplate(@Qualifier(value="clickHouseDataSource") DataSource dataSource) {
        return new ClickHouseTemplate(dataSource, true);
    }
}

