/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.co.spel;

import cn.nkpro.elcube.co.NkCustomObjectManager;
import cn.nkpro.elcube.co.spel.NkMapAccessor;
import cn.nkpro.elcube.co.spel.NkSpELInjection;
import cn.nkpro.elcube.exception.NkDefineException;
import com.alibaba.fastjson.JSON;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Component
public class NkSpELManager {
    private static final Logger log = LoggerFactory.getLogger(NkSpELManager.class);
    private static final NkMapAccessor mapAccessor = new NkMapAccessor();
    private static final ExpressionParser parser = new SpelExpressionParser();
    private static final Pattern pattern = Pattern.compile("\"?\\$\\{(?:\"[^\"]*\"|'[^']*'|\\{[^}]*\\{[^}]*}[^}]*}|\\{[^}]*}|[^\"'}])*?}\"?");
    @Autowired
    private NkCustomObjectManager customObjectManager;

    public EvaluationContext createContext(Object root) {
        StandardEvaluationContext ctx = new StandardEvaluationContext(root);
        ctx.addPropertyAccessor((PropertyAccessor)mapAccessor);
        ctx.setBeanResolver((evaluationContext, s) -> this.customObjectManager.getCustomObject("SpEL" + s, NkSpELInjection.class));
        return ctx;
    }

    public Object invoke(String el, Object root) {
        StandardEvaluationContext context = new StandardEvaluationContext(root);
        context.addPropertyAccessor((PropertyAccessor)mapAccessor);
        el = this.convert(el, (EvaluationContext)context);
        try {
            return parser.parseExpression(el).getValue((EvaluationContext)context);
        }
        catch (EvaluationException | ParseException e) {
            throw new NkDefineException(String.format("\u8868\u8fbe\u5f0f %s \u9519\u8bef: %s", el, e.getMessage()), e);
        }
    }

    public Object invoke(String el, EvaluationContext context) {
        el = this.convert(el, context);
        try {
            return parser.parseExpression(el).getValue(context);
        }
        catch (EvaluationException | ParseException e) {
            throw new NkDefineException(String.format("\u8868\u8fbe\u5f0f %s \u9519\u8bef: %s", el, e.getMessage()), e);
        }
    }

    public String convert(String input, Object root) {
        return this.convert(input, this.createContext(root));
    }

    public String convert(String input, EvaluationContext context) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return "";
        }
        Matcher matcher = pattern.matcher(input);
        boolean bool = true;
        boolean bool2 = false;
        while (matcher.find()) {
            String expression;
            if (bool && log.isDebugEnabled()) {
                bool = false;
                log.debug("\u89e3\u6790SpEL\u6a21\u7248 {}", (Object)input);
            }
            String el = expression.substring((expression = matcher.group(0)).charAt(0) == '\"' ? 3 : 2, expression.charAt(expression.length() - 1) == '\"' ? expression.length() - 2 : expression.length() - 1);
            try {
                Object value = parser.parseExpression(el).getValue(context);
                String strValue = value == null ? "null" : (value instanceof Boolean || value instanceof Number ? value.toString() : JSON.toJSONString((Object)value));
                input = input.replace(expression, strValue);
                if (log.isDebugEnabled()) {
                    log.debug("\t {} => {} >> {}", new Object[]{expression, el, strValue});
                }
            }
            catch (EvaluationException | ParseException e) {
                throw new NkDefineException(String.format("\u8868\u8fbe\u5f0f\u6a21\u7248 %s \u9519\u8bef : %s", input, expression), e);
            }
            bool2 = true;
        }
        if (bool2 && log.isDebugEnabled()) {
            log.debug("\u89e3\u6790SpEL\u6a21\u7248 \u5b8c\u6210 {}", (Object)input);
        }
        return input;
    }
}

