/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.co.spel;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class NkMapAccessor
implements PropertyAccessor {
    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{Map.class};
    }

    public boolean canRead(@NotNull EvaluationContext evaluationContext, @Nullable Object target, @NotNull String name) {
        return target instanceof Map;
    }

    @NotNull
    public TypedValue read(@NotNull EvaluationContext evaluationContext, Object target, @NotNull String name) {
        Assert.state((boolean)(target instanceof Map), (String)"Target must be of type Map");
        Map map = (Map)target;
        Object value = map.get(name);
        if (value == null && !map.containsKey(name)) {
            return new TypedValue(null);
        }
        return new TypedValue(value);
    }

    public boolean canWrite(@NotNull EvaluationContext evaluationContext, Object target, @NotNull String name) {
        return target instanceof Map;
    }

    public void write(@NotNull EvaluationContext evaluationContext, Object target, @NotNull String name, Object newValue) {
        Assert.state((boolean)(target instanceof Map), (String)"Target must be of type Map");
        Map map = (Map)target;
        map.put(name, newValue);
    }
}

