/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.co.query.model;

import cn.nkpro.elcube.annotation.Keep;
import cn.nkpro.elcube.co.query.model.DataQueryDrill;
import cn.nkpro.elcube.exception.NkDefineException;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import org.apache.commons.lang3.StringUtils;

@Keep
public class DataQueryRequest {
    private List<String> sqlList;
    private List<Select> selects;
    private Integer from = 0;
    private Integer rows = 100;
    private JSONObject conditions;
    private String order;
    private String orderField;
    private DataQueryDrill drill;

    public void setSql(String sql) {
        this.sqlList = Collections.singletonList(sql);
    }

    public static DataQueryRequest fromSql(String sql) {
        DataQueryRequest sqlSearchRequest = new DataQueryRequest();
        sqlSearchRequest.setSqlList(Collections.singletonList(sql));
        return sqlSearchRequest;
    }

    public DataQueryRequest parse() {
        this.selects = new ArrayList<Select>();
        this.sqlList = this.sqlList.stream().map(sql -> {
            try {
                Select select = (Select)CCJSqlParserUtil.parse((String)sql);
                this.selects.add(select);
                if (this.getDrill() != null && StringUtils.isNotBlank((CharSequence)this.getDrill().getFrom())) {
                    PlainSelect selectBody = (PlainSelect)select.getSelectBody();
                    SelectExpressionItem selectItem = selectBody.getSelectItems().stream().filter(s -> {
                        if (s instanceof SelectExpressionItem) {
                            SelectExpressionItem expressionItem = (SelectExpressionItem)s;
                            String alias = expressionItem.getAlias() != null ? expressionItem.getAlias().getName() : expressionItem.getExpression().toString();
                            alias = alias.replaceAll("(^\")|(\"$)", "");
                            return StringUtils.equals((CharSequence)alias, (CharSequence)this.getDrill().getFrom());
                        }
                        return false;
                    }).findFirst().orElse(null);
                    if (selectItem == null) {
                        throw new NkDefineException(String.format("\u4e0b\u94bb\u5217[%s]\u4e0d\u5b58\u5728", this.getDrill().getFrom()));
                    }
                    if (!(selectItem.getExpression() instanceof Column)) {
                        throw new NkDefineException(String.format("\u4e0b\u94bb\u5217[%s]\u4e0d\u652f\u6301", this.getDrill().getFrom()));
                    }
                    String alias = selectItem.getAlias() != null ? selectItem.getAlias().getName() : selectItem.getExpression().toString();
                    selectBody.getSelectItems().remove(selectItem);
                    selectBody.getGroupBy().getGroupByExpressionList().getExpressions().removeIf(expression -> expression instanceof Column && StringUtils.equals((CharSequence)((Column)expression).getColumnName(), (CharSequence)alias));
                    Column columnTo = new Column(this.getDrill().getTo());
                    selectBody.getSelectItems().add(new SelectExpressionItem((Expression)columnTo).withAlias(new Alias(alias)));
                    selectBody.getGroupBy().addGroupByExpressions(new Expression[]{columnTo});
                    EqualsTo equalsTo = new EqualsTo(selectItem.getExpression(), (Expression)new StringValue((String)this.getDrill().getFromValue()));
                    if (selectBody.getWhere() != null) {
                        selectBody.setWhere((Expression)new AndExpression((Expression)equalsTo, selectBody.getWhere()));
                    } else {
                        selectBody.setWhere((Expression)equalsTo);
                    }
                    if (selectBody.getGroupBy().getGroupByExpressionList().getExpressions().isEmpty()) {
                        selectBody.setGroupByElement(null);
                    }
                    return selectBody.toString();
                }
                return sql;
            }
            catch (JSQLParserException e) {
                throw new NkDefineException("\u4e0b\u94bb\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
            }
        }).collect(Collectors.toList());
        return this;
    }

    public List<String> getSqlList() {
        return this.sqlList;
    }

    public List<Select> getSelects() {
        return this.selects;
    }

    public Integer getFrom() {
        return this.from;
    }

    public Integer getRows() {
        return this.rows;
    }

    public JSONObject getConditions() {
        return this.conditions;
    }

    public String getOrder() {
        return this.order;
    }

    public String getOrderField() {
        return this.orderField;
    }

    public DataQueryDrill getDrill() {
        return this.drill;
    }

    public void setSqlList(List<String> sqlList) {
        this.sqlList = sqlList;
    }

    public void setSelects(List<Select> selects) {
        this.selects = selects;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public void setRows(Integer rows) {
        this.rows = rows;
    }

    public void setConditions(JSONObject conditions) {
        this.conditions = conditions;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public void setOrderField(String orderField) {
        this.orderField = orderField;
    }

    public void setDrill(DataQueryDrill drill) {
        this.drill = drill;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataQueryRequest)) {
            return false;
        }
        DataQueryRequest other = (DataQueryRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$sqlList = this.getSqlList();
        List<String> other$sqlList = other.getSqlList();
        if (this$sqlList == null ? other$sqlList != null : !((Object)this$sqlList).equals(other$sqlList)) {
            return false;
        }
        List<Select> this$selects = this.getSelects();
        List<Select> other$selects = other.getSelects();
        if (this$selects == null ? other$selects != null : !((Object)this$selects).equals(other$selects)) {
            return false;
        }
        Integer this$from = this.getFrom();
        Integer other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Integer this$rows = this.getRows();
        Integer other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
            return false;
        }
        JSONObject this$conditions = this.getConditions();
        JSONObject other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !this$conditions.equals(other$conditions)) {
            return false;
        }
        String this$order = this.getOrder();
        String other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) {
            return false;
        }
        String this$orderField = this.getOrderField();
        String other$orderField = other.getOrderField();
        if (this$orderField == null ? other$orderField != null : !this$orderField.equals(other$orderField)) {
            return false;
        }
        DataQueryDrill this$drill = this.getDrill();
        DataQueryDrill other$drill = other.getDrill();
        return !(this$drill == null ? other$drill != null : !((Object)this$drill).equals(other$drill));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataQueryRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $sqlList = this.getSqlList();
        result = result * 59 + ($sqlList == null ? 43 : ((Object)$sqlList).hashCode());
        List<Select> $selects = this.getSelects();
        result = result * 59 + ($selects == null ? 43 : ((Object)$selects).hashCode());
        Integer $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Integer $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        JSONObject $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : $conditions.hashCode());
        String $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        String $orderField = this.getOrderField();
        result = result * 59 + ($orderField == null ? 43 : $orderField.hashCode());
        DataQueryDrill $drill = this.getDrill();
        result = result * 59 + ($drill == null ? 43 : ((Object)$drill).hashCode());
        return result;
    }

    public String toString() {
        return "DataQueryRequest(sqlList=" + this.getSqlList() + ", selects=" + this.getSelects() + ", from=" + this.getFrom() + ", rows=" + this.getRows() + ", conditions=" + this.getConditions() + ", order=" + this.getOrder() + ", orderField=" + this.getOrderField() + ", drill=" + this.getDrill() + ")";
    }
}

