/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.co.query;

import cn.nkpro.elcube.co.NkCustomObjectManager;
import cn.nkpro.elcube.co.query.DataQueryService;
import cn.nkpro.elcube.co.query.model.DataSourceDef;
import cn.nkpro.elcube.exception.NkDefineException;
import cn.nkpro.elcube.platform.service.PlatformRegistryService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSourceManager {
    @Autowired
    private NkCustomObjectManager customObjectManager;
    @Autowired
    private PlatformRegistryService registryService;
    private static final String REG_KEY = "@DATASET";

    public Collection<DataSourceDef> getDataSources() {
        return this.registryService.getAllByType(REG_KEY).stream().map(registry -> {
            DataSourceDef def = (DataSourceDef)JSON.parseObject((String)registry.getContent(), DataSourceDef.class);
            def.setName(registry.getRegKey());
            return def;
        }).sorted(Comparator.comparing(DataSourceDef::getName)).collect(Collectors.toList());
    }

    public DataQueryService getService(String datasourceName) {
        JSONObject def = (JSONObject)this.registryService.getJSON(REG_KEY, datasourceName = datasourceName.replaceAll("(^\")|(\"$)", ""));
        if (def == null) {
            throw new NkDefineException("\u6570\u636e\u6e90\u6ca1\u6709\u627e\u5230");
        }
        return this.customObjectManager.getCustomObject(def.getString("service"), DataQueryService.class);
    }
}

