/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.co.meter;

import cn.nkpro.elcube.co.meter.NkAbstractMeter;
import cn.nkpro.elcube.co.query.DataSourceManager;
import cn.nkpro.elcube.co.query.model.DataQueryRequest;
import cn.nkpro.elcube.data.redis.RedisSupport;
import cn.nkpro.elcube.exception.NkDefineException;
import cn.nkpro.elcube.security.SecurityUtilz;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.DigestUtils;

public abstract class NkAbstractEqlMeter
extends NkAbstractMeter<List> {
    private static final TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
    @Autowired
    private RedisSupport<List> redisSupport;
    @Autowired
    private DataSourceManager dataSourceManager;

    public List getData(Object config) {
        String sql = (String)((Map)config).get("sql");
        if (StringUtils.isBlank((CharSequence)sql)) {
            return Collections.emptyList();
        }
        Select select = null;
        try {
            select = (Select)CCJSqlParserUtil.parse((String)sql);
        }
        catch (JSQLParserException e) {
            e.printStackTrace();
            throw new NkDefineException("\u67e5\u8be2\u547d\u4ee4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String tableName = tablesNamesFinder.getTableList((Statement)select).stream().findFirst().orElse(null);
        if (tableName == null) {
            throw new NkDefineException("\u6570\u636e\u6e90\u6ca1\u6709\u6307\u5b9a");
        }
        String key = SecurityUtilz.getUser().getId() + ':' + DigestUtils.md5DigestAsHex((byte[])sql.getBytes());
        List list = this.redisSupport.getIfAbsent(key, () -> this.dataSourceManager.getService(tableName).queryList(DataQueryRequest.fromSql(sql)).getList());
        this.redisSupport.expire(key, 60L);
        return list;
    }
}

