/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.co.fs.defaults;

import cn.nkpro.elcube.basic.NkProperties;
import cn.nkpro.elcube.co.fs.FSConfig;
import cn.nkpro.elcube.co.fs.FSSupport;
import cn.nkpro.elcube.co.fs.FileUploadStatus;
import cn.nkpro.elcube.security.UserAccountService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;

public class DefaultFileSupportImpl
implements FSSupport<Map<String, Object>> {
    private Format format = new SimpleDateFormat(String.format("yyyyMMdd%sHHmmss", File.separator));
    @Autowired
    private NkProperties properties;
    @Autowired
    private UserAccountService accountService;

    @Override
    public ResponseEntity<Map<String, Object>> init(FSConfig file) {
        LinkedHashMap<String, Object> header = new LinkedHashMap<String, Object>();
        header.put("NK-Token", this.accountService.createToken().get("accessToken"));
        header.put("key", "${filename}");
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("host", "/api/fs/upload");
        response.put("path", "");
        response.put("filename", "");
        response.put("header", header);
        return ResponseEntity.ok(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileUploadStatus upload(MultipartFile file) {
        FileUploadStatus status = new FileUploadStatus();
        OutputStream os = null;
        InputStream is = null;
        try {
            String url = String.join((CharSequence)File.separator, this.format.format(new Date()), UUID.randomUUID().toString(), file.getOriginalFilename()).replace("\\", "/");
            String path = String.join((CharSequence)File.separator, this.properties.getFileRootPath(), url).replace("\\", "/");
            File targetFile = new File(path);
            if (targetFile.getParentFile().mkdirs()) {
                os = new FileOutputStream(targetFile);
                is = file.getInputStream();
                byte[] b = new byte[1024];
                while (is.read(b) != -1) {
                    os.write(b);
                }
                status.setName(file.getOriginalFilename());
                status.setStatus("done");
                status.setUrl(url);
                status.setThumbUrl(url);
            } else {
                status.setStatus("error");
                status.setMessage("\u521b\u5efa\u6587\u4ef6\u76ee\u5f55\u53d1\u751f\u9519\u8bef");
            }
        }
        catch (IOException e) {
            status.setStatus("error");
            status.setMessage(e.getMessage());
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                    os.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return status;
    }

    @Override
    public void moveTo(String source, String target) {
    }

    @Override
    public ResponseEntity download(String url) {
        return ResponseEntity.ok((Object)("/api/fs/d/" + url));
    }

    public ResponseEntity downloadFile(String url) {
        File file = new File(String.join((CharSequence)File.separator, this.properties.getFileRootPath(), url));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentDispositionFormData("attachment", new String(file.getName().getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        headers.setContentLength(file.length());
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(file.length()).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)new FileSystemResource(file));
    }
}

