/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.co.fs.defaults;

import cn.nkpro.elcube.basic.NkProperties;
import cn.nkpro.elcube.co.fs.FSConfig;
import cn.nkpro.elcube.co.fs.FSSupport;
import cn.nkpro.elcube.co.fs.FileUploadStatus;
import cn.nkpro.elcube.co.fs.properties.HuaweiProperties;
import com.obs.services.ObsClient;
import com.obs.services.ObsConfiguration;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.PostSignatureRequest;
import com.obs.services.model.PostSignatureResponse;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;

public class DefaultFileSupportHuaweiOBS
implements FSSupport<Map<String, Object>>,
InitializingBean,
DisposableBean {
    private Format format = new SimpleDateFormat("yyyyMMdd/HHmmss/");
    private static AuthTypeEnum authType = AuthTypeEnum.OBS;
    @Autowired
    private NkProperties tfmsProperties;
    @Autowired
    private HuaweiProperties huawei;
    private ObsClient obsClient;

    @Override
    public ResponseEntity<Map<String, Object>> init(FSConfig file) {
        String path = this.defaultPath(this.huawei.getObs().getPath(), this.tfmsProperties);
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("x-obs-acl", "public-read");
            data.put("content-type", "text/plain");
            PostSignatureRequest request = new PostSignatureRequest();
            request.setExpires(30L);
            request.setFormParams(data);
            PostSignatureResponse response = this.obsClient.createPostSignature(request);
            data.put("accesskeyid", this.huawei.getAccessKeyId());
            data.put("signature", response.getSignature());
            data.put("policy", response.getPolicy());
            data.put("key", path + file.getName());
            LinkedHashMap<String, Object> responseMap = new LinkedHashMap<String, Object>();
            responseMap.put("host", this.huawei.getObs().getHost());
            responseMap.put("path", path);
            responseMap.put("filename", file.getName());
            responseMap.put("data", data);
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Access-Control-Allow-Origin", new String[]{"*"})).header("Access-Control-Allow-Methods", new String[]{"GET, POST"})).body(responseMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.badRequest().body(null);
        }
    }

    @Override
    public FileUploadStatus upload(MultipartFile file) {
        throw new RuntimeException("\u4e0d\u652f\u6301\u64cd\u4f5c");
    }

    @Override
    public void moveTo(String source, String target) {
    }

    @Override
    public ResponseEntity download(String url) {
        TemporarySignatureRequest request = new TemporarySignatureRequest(HttpMethodEnum.GET, 30L);
        request.setBucketName(this.huawei.getObs().getBucket());
        request.setObjectKey(url);
        request.setQueryParams(Collections.singletonMap("response-content-type", "application/octet-stream"));
        TemporarySignatureResponse response = this.obsClient.createTemporarySignature(request);
        return ResponseEntity.ok((Object)response.getSignedUrl());
    }

    public void afterPropertiesSet() {
        ObsConfiguration config = new ObsConfiguration();
        config.setEndPoint(this.huawei.getObs().getEndpoint());
        config.setAuthType(authType);
        this.obsClient = new ObsClient(this.huawei.getAccessKeyId(), this.huawei.getAccessKeySecret(), config);
    }

    public void destroy() throws Exception {
        this.obsClient.close();
    }
}

