/*
 * Decompiled with CFR 0.152.
 */
package cn.nkpro.elcube.co.fs.defaults;

import cn.nkpro.elcube.basic.NkProperties;
import cn.nkpro.elcube.co.fs.FSConfig;
import cn.nkpro.elcube.co.fs.FSSupport;
import cn.nkpro.elcube.co.fs.FileUploadStatus;
import cn.nkpro.elcube.co.fs.properties.AliyunProperties;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import java.nio.charset.StandardCharsets;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;

public class DefaultFileSupportAliyunOSS
implements FSSupport<Map<String, Object>>,
InitializingBean {
    private Format format = new SimpleDateFormat("yyyyMMdd/HHmmss/");
    @Autowired
    private NkProperties tfmsProperties;
    @Autowired
    private AliyunProperties aliyunProperties;
    private OSS ossClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseEntity<Map<String, Object>> init(FSConfig file) {
        String path = this.defaultPath(this.aliyunProperties.getOss().getPath(), this.tfmsProperties);
        try {
            long expireEndTime = System.currentTimeMillis() + 30000L;
            Date expiration = new Date(expireEndTime);
            PolicyConditions policyConds = new PolicyConditions();
            policyConds.addConditionItem("content-length-range", 0L, 0x6400000L);
            policyConds.addConditionItem(MatchMode.StartWith, "key", this.aliyunProperties.getOss().getPath());
            String postPolicy = this.ossClient.generatePostPolicy(expiration, policyConds);
            byte[] binaryData = postPolicy.getBytes(StandardCharsets.UTF_8);
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = this.ossClient.calculatePostSignature(postPolicy);
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            data.put("OSSAccessKeyId", this.aliyunProperties.getAccessKeyId());
            data.put("signature", postSignature);
            data.put("policy", encodedPolicy);
            data.put("path", path);
            data.put("expire", String.valueOf(expireEndTime / 1000L));
            data.put("key", path + file.getName());
            data.put("success_action_status", "200");
            LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
            response.put("host", this.aliyunProperties.getOss().getHost());
            response.put("path", path);
            response.put("filename", file.getName());
            response.put("data", data);
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Access-Control-Allow-Origin", new String[]{"*"})).header("Access-Control-Allow-Methods", new String[]{"GET, POST"})).body(response);
            return responseEntity;
        }
        catch (Exception e) {
            e.printStackTrace();
            ResponseEntity responseEntity = ResponseEntity.badRequest().body(null);
            return responseEntity;
        }
        finally {
            this.ossClient.shutdown();
        }
    }

    @Override
    public FileUploadStatus upload(MultipartFile file) {
        throw new RuntimeException("\u4e0d\u652f\u6301\u64cd\u4f5c");
    }

    @Override
    public void moveTo(String source, String target) {
    }

    @Override
    public ResponseEntity download(String url) {
        GeneratePresignedUrlRequest generatePresignedUrlRequest = new GeneratePresignedUrlRequest(this.aliyunProperties.getOss().getBucket(), url, HttpMethod.GET);
        generatePresignedUrlRequest.setExpiration(new Date(new Date().getTime() + 30000L));
        generatePresignedUrlRequest.setHeaders(new HashMap<String, String>(Collections.singletonMap("response-content-type", "application/octet-stream")));
        return ResponseEntity.ok((Object)this.ossClient.generatePresignedUrl(generatePresignedUrlRequest).toString());
    }

    public void afterPropertiesSet() {
        this.ossClient = new OSSClientBuilder().build(this.aliyunProperties.getOss().getEndpoint(), this.aliyunProperties.getAccessKeyId(), this.aliyunProperties.getAccessKeySecret());
    }
}

